package com.stream.brt.tool.io;

import com.stream.brt.tool.log.Logger;
import com.stream.brt.tool.log.LoggerFactory;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 */
public class NoCloseInputStream extends FilterInputStream {
    private static Logger logger = LoggerFactory.getLogger(NoCloseInputStream.class.getSimpleName());
    /**
     * Creates a <code>FilterInputStream</code>
     * by assigning the  argument <code>in</code>
     * to the field <code>this.in</code> so as
     * to remember it for later use.
     *
     * @param in the underlying input stream, or <code>null</code> if
     *           this instance is to be created without an underlying stream.
     */
    public NoCloseInputStream(InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
        //do nothing
        logger.error("proxy close......");
    }
}
