package com.stream.brt.engine;

import com.stream.brt.engine.model.LiveSliceGroup;
import com.stream.tool.log.Logger;
import com.stream.tool.log.LoggerFactory;

import java.util.*;

public class BrtStat {
    private final static Logger logger = LoggerFactory.getLogger(BrtStat.class.getSimpleName());
    private final static Map<Integer, Integer> PROXY_PORT_SEQ_MAPPING = new HashMap<>();
    private final static TreeMap<Integer, TreeMap<Long, Pair<Long,String>>> REQUEST_STAT = new TreeMap<>();
    private static int seq = (int)(Math.random() * 10000);
    private static String dftEndTag = "grpWE";
    private static String endTag = dftEndTag;
    private static Listener listener = null;

    public interface Listener {
        void onBrtStatUpdate(String statInfo);
    }

    public static void setListener(Listener l) {
        listener = l;
    }

    public static synchronized void add(int proxyPort) {
        ++seq;
        PROXY_PORT_SEQ_MAPPING.put(proxyPort, seq);
    }

    public static int getSeq() {
        return seq;
    }

    public static void setEndTag(String endTag) {
        BrtStat.endTag =endTag;
    }

    public static synchronized void put(int seq, String tag) {
        long current  = System.currentTimeMillis();
        put(seq, tag, current, current);
    }

    public static synchronized void put(int seq, String tag, long seqTime, long time) {
        if (listener == null)
            return;

        if (seq != BrtStat.seq)
            return;

        TreeMap<Long, Pair<Long, String>> treeMap = REQUEST_STAT.get(seq);
        if (treeMap == null) {
            if (REQUEST_STAT.size() > 20) {
                REQUEST_STAT.remove(REQUEST_STAT.firstKey());
            }
            treeMap = new TreeMap<>();
            REQUEST_STAT.put(seq, treeMap);
        }

        Pair<Long, String> pair = new Pair<>();
        pair.left = time;
        pair.right = tag;
        treeMap.put(seqTime, pair);
    }


    public static void put(LiveSliceGroup sliceGroup, ResendStat resendStat, BrtConnect.RemoveGrpEvent event) {
        int resendSlices = sliceGroup.getCount() - sliceGroup.getAvailableCount();
        int lostPercent = resendSlices * 100 / sliceGroup.getCount();
        sliceGroup.setLostPercent(lostPercent);
        sliceGroup.setLostCount(resendSlices);
        resendStat.statSliceGroup(sliceGroup, event);

        Listener l = listener;
        if (l == null)
            return;

        int seq = sliceGroup.getStatSeq();
        long current = System.currentTimeMillis();
        String dropTag = null;
        switch (event) {
            case DROP_TIMEOUT:
                dropTag = "grpTimeout";
                break;
            case DROP_OVERDUE:
                dropTag = "grpOverdue";
                break;
            case DROP_OVERCACHE:
                dropTag = "grpOverCache";
                break;
        }

        BrtStat.put(seq, "grpS", current++, sliceGroup.getBeginTime());
        BrtStat.put(seq, "grpSeqNo.", current++, sliceGroup.getBeginTime() + sliceGroup.getExSeq());
        BrtStat.put(seq, "#null", current++, sliceGroup.getBeginTime());
        long beginTime;
        if (dropTag != null) {
            BrtStat.put(seq, dropTag, current++, current);
            long lostPercent1st = current + sliceGroup.getFirstLostPercent();
            BrtStat.put(seq, "lost1%", current++, lostPercent1st);
            long lostCnt1st = lostPercent1st + sliceGroup.getFirstLostCount();
            BrtStat.put(seq, "lost1∑", current++, lostCnt1st);
            long resendRounds = lostCnt1st + sliceGroup.getResendRounds();
            BrtStat.put(seq, "rsntRnds", current++, resendRounds);
            long resendPackets = resendRounds + sliceGroup.getResendCount();
            BrtStat.put(seq, "rsntPkts", current++, resendPackets);
            long lostPercent2nd = resendPackets + sliceGroup.getLostPercent();
            BrtStat.put(seq, "lost2%", current++, lostPercent2nd);
            long lostCnt2nd = lostPercent2nd + sliceGroup.getLostCount();
            BrtStat.put(seq, "lost2∑", current++, lostCnt2nd);
            BrtStat.put(seq, "RTT", current++,  lostCnt2nd + sliceGroup.getRtt());
            BrtStat.put(seq, "#null0", current, current);
        } else {
            if (sliceGroup.getSubGroupDataShards() > 0 && sliceGroup.getSubGroupParityShards() > 0) {
                BrtStat.put(seq, "grpDS", current++, sliceGroup.getDecodeBeginTime());
                BrtStat.put(seq, "grpDE", current++, sliceGroup.getDecodeEndTime());
                beginTime = sliceGroup.getDecodeEndTime();
            } else {
                beginTime = sliceGroup.getBeginTime();
            }
            long lostPercent1st = beginTime + sliceGroup.getFirstLostPercent();
            BrtStat.put(seq, "lost1%", current++, lostPercent1st);
            long lostCnt1st = lostPercent1st + sliceGroup.getFirstLostCount();
            BrtStat.put(seq, "lost1∑", current++, lostCnt1st);
            long resendRounds = lostCnt1st + sliceGroup.getResendRounds();
            BrtStat.put(seq, "rsntRnds", current++, resendRounds);
            long resendPackets = resendRounds + sliceGroup.getResendCount();
            BrtStat.put(seq, "rsntPkts", current++, resendPackets);
            long lostPercent2nd = resendPackets + sliceGroup.getLostPercent();
            BrtStat.put(seq, "lost2%", current++, lostPercent2nd);
            long lostCnt2nd = lostPercent2nd + sliceGroup.getLostCount();
            BrtStat.put(seq, "lost2∑", current++, lostCnt2nd);
            BrtStat.put(seq, "#null0", current++, beginTime);
            BrtStat.put(seq, "grpWS", current++, sliceGroup.getSendBeginTime());
            BrtStat.put(seq, "grpWE", current++, sliceGroup.getSendEndTime());
            BrtStat.put(seq, "RTT", current++, sliceGroup.getSendEndTime() + sliceGroup.getRtt());
            BrtStat.put(seq, "#null1", current, sliceGroup.getSendEndTime());
        }

        String statInfo = generateStatInfo();
        l.onBrtStatUpdate(statInfo);
    }

    private static String generateStatInfo() {
        List<Integer> seqs = seqs();
        List<Pair<LinkedHashMap<String, Long>, Pair<Integer,List<Long>>>> mainDisplayLines = new ArrayList<>();
        List<Pair<LinkedHashMap<String, Long>, Pair<Integer,List<Long>>>> currentDetailLines = new ArrayList<>();
        List<Pair<Integer,List<Long>>> toRemoveList = new ArrayList<>();

        // calculate duration between steps of groups
        for (int seq : seqs) {
            long lastTime = 0;
            TreeMap<Long, Pair<Long,String>> treeMap = REQUEST_STAT.get(seq);
            if (treeMap == null)
                continue;
            treeMap = copy(treeMap);

            List<Long> times = new ArrayList<>(treeMap.keySet());
            LinkedHashMap<String, Long> linkedHashMap = new LinkedHashMap<>();
            List<Long> keyList = new ArrayList<>();
            LinkedHashMap<String, Long> first = linkedHashMap;
            for (Pair<LinkedHashMap<String, Long>, Pair<Integer,List<Long>>> pair:currentDetailLines) {
                toRemoveList.add(pair.right);
            }
            currentDetailLines = new ArrayList<>();
            long lastTimeOfFirstLine = 0;
            for (long time : times) {
                keyList.add(time);
                Pair<Long,String> pair = treeMap.get(time);
                if (pair == null)
                    continue;

                String tag = pair.right;

                if (lastTimeOfFirstLine > 0 && tag.equals(endTag)) {
                    first.put(tag, pair.left - lastTimeOfFirstLine);
                    lastTimeOfFirstLine = 0;
                    continue;
                }

                if (linkedHashMap.containsKey(tag)) {
                    if (linkedHashMap == first) {
                        if (!tag.equals(endTag)) {
                            lastTimeOfFirstLine = pair.left;
                        }
                        mainDisplayLines.add(new Pair<>(linkedHashMap, new Pair<>(seq, keyList)));
                    } else {
                        currentDetailLines.add(new Pair<>(linkedHashMap, new Pair<>(seq, keyList)));
                    }
                    lastTime = 0;
                    linkedHashMap = new LinkedHashMap<>();
                    keyList = new ArrayList<>();
                }

                long duration = lastTime == 0 ? 0 : pair.left - lastTime;
                lastTime = pair.left;

                linkedHashMap.put(tag, duration);
            }

            if (linkedHashMap == first) {
                mainDisplayLines.add(new Pair<>(linkedHashMap, new Pair<>(seq, keyList)));
            } else {
                currentDetailLines.add(new Pair<>(linkedHashMap, new Pair<>(seq, keyList)));
            }
        }

        // generate main (the first group after channel changed) stat info
        int beginPos = 0;
        if (mainDisplayLines.size() > 10) {
            beginPos = mainDisplayLines.size() - 10;
        }

        int lines = 0;
        Map<String, Integer> tagPos = new HashMap<>();
        StringBuilder builder = new StringBuilder();
        int lineSize = 0;
        String lastTag = "";
        Set<Integer> displaySeqs = new HashSet<>();
        for (int i=0; i<mainDisplayLines.size(); i++) {
            Pair<LinkedHashMap<String, Long>, Pair<Integer,List<Long>>> pair = mainDisplayLines.get(i);
            if (i < beginPos) {
                toRemoveList.add(pair.right);
                continue;
            }

            displaySeqs.add(pair.right.left);
            LinkedHashMap<String, Long> map = pair.left;
            StringBuilder tagBuilder = new StringBuilder();
            StringBuilder durBuilder = new StringBuilder();
            tagPos = new HashMap<>();
            int shift = 0;
            int totalDuration = 0;
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                String tag = entry.getKey();
                long value = entry.getValue();
                totalDuration += value;
                if (tag.startsWith("#null"))
                    continue;
                String  duration = Long.toString(value);
                int tagBeginPos = tagBuilder.length();
                tagBuilder.append(tag).append("__");
                durBuilder.append(duration);
                while (tagBuilder.length() + shift < durBuilder.length()) {
                    tagBuilder.append("_");
                }
                while (durBuilder.length() < tagBuilder.length() + shift) {
                    durBuilder.append("_");
                }
                tagPos.put(tag, tagBeginPos);
                if (duration.length() < 4) {
                    if (duration.length() < tag.length() / 3)
                        shift++;
                } else {
                    shift += (tag.length() / duration.length());
                }
            }

            tagBuilder.append("All");
            durBuilder.append(Integer.toString(totalDuration));

            if (lineSize < tagBuilder.length()) {
                lineSize = tagBuilder.length();
            }

            String tag = tagBuilder.toString();
            if (!lastTag.equals(tag)) {
                builder.append(tag).append(System.lineSeparator());
                lastTag = tag;
                lines++;
            }
            builder.append(durBuilder).append(System.lineSeparator());
            lines++;
        }

        addSpliteLine(builder, lineSize);

        // generate current channel latest group stat info
        beginPos = 0;
        if (currentDetailLines.size() > (30 - lines)) {
            beginPos = currentDetailLines.size() - (30 - lines);
        }

        for (int i=0; i<currentDetailLines.size(); i++) {
            Pair<LinkedHashMap<String, Long>, Pair<Integer,List<Long>>> pair = currentDetailLines.get(i);
            if (i < beginPos) {
                toRemoveList.add(pair.right);
                continue;
            }
            displaySeqs.add(pair.right.left);
            LinkedHashMap<String, Long> map = pair.left;
            StringBuilder tagBuilder = new StringBuilder();
            StringBuilder durBuilder = new StringBuilder();
            boolean isFirstTag = true;
            int shift = 0;
            int totalDuration = 0;
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                String tag = entry.getKey();
                long value = entry.getValue();
                totalDuration += value;

                if (tag.startsWith("#null"))
                    continue;

                if (isFirstTag) {
                    Integer pos = tagPos.get(tag);
                    if (pos == null)
                        pos = 0;
                    for (int j = 0; j<pos; j++) {
                        tagBuilder.append("_");
                        durBuilder.append("_");
                    }
                    isFirstTag = false;
                }
                String  duration = Long.toString(value);
                tagBuilder.append(tag).append("__");
                durBuilder.append(duration);
                while (tagBuilder.length() + shift  < durBuilder.length()) {
                    tagBuilder.append("_");
                }
                while (durBuilder.length() < tagBuilder.length() + shift ) {
                    durBuilder.append("_");
                }
                if (duration.length() < 4) {
                    if (duration.length() < tag.length() / 3)
                        shift++;
                } else {
                    shift += (tag.length() / duration.length());
                }
            }

            tagBuilder.append("All");
            durBuilder.append(Integer.toString(totalDuration));

            String tag = tagBuilder.toString();
            if (!lastTag.equals(tag)) {
                builder.append(tag).append(System.lineSeparator());
                lastTag = tag;
                lines++;
            }
            builder.append(durBuilder).append(System.lineSeparator());
            lines++;
        }

        remove(seqs, displaySeqs, toRemoveList);

        return builder.toString();
    }

    // remove hide object, release memory
    private static synchronized void remove(List<Integer> seqs, Set<Integer> displaySeqs,
                                            List<Pair<Integer,List<Long>>> toRemoveList) {
        for (Integer seq:seqs) {
            if (displaySeqs.contains(seq))
                continue;
            REQUEST_STAT.remove(seq);
        }

        for (Pair<Integer,List<Long>> pair:toRemoveList) {
            TreeMap<Long, Pair<Long,String>> treeMap = REQUEST_STAT.get(pair.left);
            if (treeMap == null)
                continue;
            for (Long key:pair.right) {
                treeMap.remove(key);
            }
        }
    }

    private static void addSpliteLine(StringBuilder builder, int lineSize) {
        String title = "GROUP_STATISTICS";

        int half = (lineSize - (title.length()<<1))>>1;
        int i=0;
        StringBuilder stringBuilder = new StringBuilder();
        while (i<2) {
            stringBuilder.append("-");
            i++;
        }

        while (i<half-2) {
            stringBuilder.append("=");
            i++;
        }
        while (i<half) {
            stringBuilder.append("-");
            i++;
        }

        String spliter = stringBuilder.toString();
        builder.append(spliter).append(title).append(spliter).append(System.lineSeparator());
    }

    private static synchronized TreeMap<Long, Pair<Long,String>> copy(TreeMap<Long, Pair<Long,String>> treeMap) {
        return new TreeMap<>(treeMap);
    }

    private static synchronized List<Integer> seqs() {
        return new ArrayList<>(REQUEST_STAT.keySet());
    }
}
