package com.stream.brt.engine.metric;

import com.stream.brt.engine.BrtConnect;
import com.stream.brt.engine.model.BrtUrlInfo;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

public class BrtEngineMetric {
    private BrtMetricInfo mChannelMetricInfo;
    private boolean mMetricOn;
    private boolean mWaitingGrpFinish;
    private long mLastAuthStartTime;
    private BrtMetricStorage mStorage;

    public BrtEngineMetric(boolean isMetricOn, BrtMetricStorage storage) {
        mMetricOn = isMetricOn;
        mWaitingGrpFinish = true;
        mStorage = storage;
    }

    public void start() {
        if (!mMetricOn) return;
        mChannelMetricInfo = new BrtMetricInfo();
        mChannelMetricInfo.startTime = System.currentTimeMillis();
    }

    public void stop() {
        if (!mMetricOn) return;
        mChannelMetricInfo.endTime = System.currentTimeMillis();
        // 保存metric信息
        if (mStorage != null)
            mStorage.saveBrtMetric(mChannelMetricInfo.betterMe());
    }

    public void authStart(String mediaCode) {
        if (!mMetricOn) return;
        mWaitingGrpFinish = true;
        mChannelMetricInfo.authTimes++;
        mChannelMetricInfo.mediaCode = mediaCode;
        mLastAuthStartTime = System.currentTimeMillis();
    }

    public void authSuccess(List<BrtUrlInfo.ServerInfo> serverInfos) {
        if (!mMetricOn) return;
        mChannelMetricInfo.authSuccessTimes++;
        String server = StringUtils.join(serverInfos, ',');
        mChannelMetricInfo.tryServer(server, "auth success");
    }

    public void authFailure(List<BrtUrlInfo.ServerInfo> serverInfos) {
        if (!mMetricOn) return;
        mChannelMetricInfo.authFailureTimes++;
        String server = StringUtils.join(serverInfos, ',');
        mChannelMetricInfo.tryServer(server, "auth failure");
    }

    public void tryServer(List<BrtUrlInfo.ServerInfo> serverInfos, String message) {
        if (!mMetricOn) return;
        String server = StringUtils.join(serverInfos, ',');
        mChannelMetricInfo.tryServer(server, message);
    }

    public void finishGroup(long costTime, int sliceCnt, int resendSliceCnt, int resendPacketCnt) {
        try {
            if (!mMetricOn) return;
            // 本地接收时长
            if (mWaitingGrpFinish) {
                mWaitingGrpFinish = false;
                mChannelMetricInfo.recvDur = System.currentTimeMillis() - mLastAuthStartTime;
            }
            mChannelMetricInfo.finishGroup(costTime, sliceCnt, resendSliceCnt, resendPacketCnt);
        } catch (Exception ignored) {

        }
    }

    public void dropGroup(BrtConnect.RemoveGrpEvent dropType, int sliceCnt, int resendSliceCnt, int resendPacketCnt, long costTime) {
        try {
            if (!mMetricOn) return;
            mChannelMetricInfo.dropGroup(dropType, sliceCnt, resendSliceCnt, resendPacketCnt, costTime);
        } catch (Exception ignored) {

        }
    }

    public void saveBrtMetric(Map metric) {
        if (mStorage != null) {
            mStorage.saveBrtMetric(metric);
        }
    }
}
