package com.stream.brt.engine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 */
public class BrtUrlInfo {
    public static class ServerInfo {
        public final String host;
        public final int port;

        public ServerInfo(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerInfo that = (ServerInfo) o;

            if (port != that.port) return false;
            return host.equals(that.host);
        }

        @Override
        public int hashCode() {
            int result = host.hashCode();
            result = 31 * result + port;
            return result;
        }

        @Override
        public String toString() {
            return host + ":" + port;
        }
    }

    private String scheme;
    private List<List<ServerInfo>> serverInfos;
    private String path;
    private Map<String, String> paramMap;

    public BrtUrlInfo(String scheme, List<List<ServerInfo>> serverInfos, String path, Map<String, String> paramMap) {
        this.scheme = scheme;
        this.serverInfos = serverInfos;
        this.path = path;
        this.paramMap = paramMap;
    }

    public String getScheme() {
        return scheme;
    }

    public List<List<ServerInfo>> getServerInfos() {
        return serverInfos;
    }

    public String getPath() {
        return path;
    }

    public Map<String, String> getParamMap() {
        return paramMap;
    }
}
