package com.stream.brt.engine.model;

public class LiveSliceSubGroup {
    private int subGroupBaseSeq;
    private int sugGroupSeq;
    private int dataShards;
    private int parityShards;

    private LiveSlice[] slices;
    private long beginTime;
    private int completeCnt = 0;

    public LiveSliceSubGroup(int subGroupBaseSeq, int subGroupDataShards, int subGroupParityShards) {
        int count = subGroupDataShards + subGroupParityShards;
        this.subGroupBaseSeq = subGroupBaseSeq;
        slices = new LiveSlice[count];
        this.beginTime = System.currentTimeMillis();
    }

    public int getSugGroupSeq() {
        return sugGroupSeq;
    }

    public void setSugGroupSeq(int sugGroupSeq) {
        this.sugGroupSeq = sugGroupSeq;
    }

    public int getDataShards() {
        return dataShards;
    }

    public void setDataShards(int dataShards) {
        this.dataShards = dataShards;
    }

    public int getParityShards() {
        return parityShards;
    }

    public void setParityShards(int parityShards) {
        this.parityShards = parityShards;
    }

    public LiveSlice[] getSlices() {
        return slices;
    }

    public boolean addSlice(LiveSlice slice) {
        int index = slice.seq - subGroupBaseSeq;
        if (index >= slices.length) {
            return false;
        }

        if (slices[index] != null)
            return false;
        slices[index] = slice;

        completeCnt++;

        return true;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public boolean isComplete() {
        return completeCnt >= dataShards;
    }
}
