package com.stream.brt.tool.log;


import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by elegant.wang on 2016/9/6.
 */
public class DefaultLogger implements LoggerInterface {
    @Override
    public void log(int priority, String tag, String message, Throwable t) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String level = "N";
        switch (priority){
            case 2:
                level = "T";
                break;
            case 3:
                level = "D";
                break;
            case 4:
                level = "I";
                break;
            case 5:
                level = "W";
                break;
            case 6:
                level = "E";
                break;
        }
        System.out.println("[" + sdf.format(new Date()) + "]" + "[" + level + "]" + "[" + tag + "] " + message);
        if(t != null)
            t.printStackTrace();
    }
}
