package com.stream.prt;

import com.ott.trans.JniApiImpl;
import com.ott.trans.JniPrtListener;
import com.ott.trans.NetworkState;
import com.ott.trans.PrtListenerManager;
import com.ott.trans.jni.N2JMain;
import com.stream.brt.engine.BrtConnectListener;
import com.stream.brt.engine.BrtEngineConfig;
import com.stream.brt.engine.PrtEngineConfig;
import com.stream.brt.engine.ValueProvider;
import com.stream.brt.tool.log.Logger;
import com.stream.brt.tool.log.LoggerFactory;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PrtConnect {
    public static final String KEY_TRANS_MASK = "trans_mask";
    private static final String KEY_OP_CFG_ADDI = "addi";
    private static final String KEY_OP_CFG_PRID = "prid";
    private static final String KEY_OP_CFG_TACKER_GROUP = "tracker_select_strategy";

    private static boolean JNI_PARAM_SET = false;

    private static Logger logger = LoggerFactory.getLogger(PrtConnect.class.getSimpleName());

    private String workPath;
    private String cfgFile;
    private String logFile;

    private BrtConnectListener connectListener;
    private PrtEngineCallback prtEngineCallback;
    private JniPrtListener jniPrtListener;
    private int currChannelIndex = 0;
    private boolean mConnected = false;

    public PrtConnect(String jniFullName, String bikCoreSoFullName, PrtEngineCallback callback, JniPrtListener tsDataListener) {
        if (null != callback) {
            this.workPath = callback.getWorkPath();
            this.cfgFile = callback.getCfgFile();
            this.logFile = callback.getLogFile();
        }

        logger.info("spp PrtConnect");
        prtEngineCallback = callback;
        this.jniPrtListener = tsDataListener;
        JniApiImpl.init(bikCoreSoFullName, jniFullName);
        if (!JNI_PARAM_SET) {
            JNI_PARAM_SET = true;
            if (PrtEngineConfig.prtParams != null && PrtEngineConfig.prtParams.length() > 0) {
                JniApiImpl.getInstance().setParam(PrtEngineConfig.prtParams, null);
            }
        }
        int ret = JniApiImpl.getInstance().init(workPath, cfgFile, null);
    }

    public static String GetInetAddress(String host) {
        String IPAddress = "";
        InetAddress ReturnStr1 = null;
        try {
            ReturnStr1 = java.net.InetAddress.getByName(host);
            IPAddress = ReturnStr1.getHostAddress();
        } catch (Exception e) {
            return "";
        }
        return IPAddress;
    }

    public void initModule(String brtUrl, String channelID, BrtConnectListener connectListener, ValueProvider provider) throws Exception {
        this.connectListener = connectListener;
        connectListener.onStart();
        if (prtEngineCallback == null) {
            throw new RuntimeException("prt connect init module with a null prtEngineCallback");
        }
        String manualServerId = provider.val(BrtEngineConfig.ENG_MANUAL_SERVER_ID, "");
        String releaseId = provider.val(BrtEngineConfig.BRT_KEY_CHN, "");
        String channelGroupId = provider.val(BrtEngineConfig.ENG_CHANNEL_GROUP_ID, "0");
        StringBuilder sysParamsBuilder = new StringBuilder();
        sysParamsBuilder.append(String.format("aid=%s", prtEngineCallback.getAccountId()));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "cid=%s", String.valueOf(prtEngineCallback.getConnectionId())));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "tkn=%s", prtEngineCallback.getToken(brtUrl)));
        sysParamsBuilder.append(JniApiImpl.seperator_and + "vlc=1");
        sysParamsBuilder.append(JniApiImpl.seperator_and + "prt=1");
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "localip=%s", prtEngineCallback.getLocalIP()));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "tacker_group=%s", prtEngineCallback.getCfgValue(KEY_OP_CFG_TACKER_GROUP, Character.class, 's')));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "fecOn=%d", prtEngineCallback.getCfgValue(PrtEngineConfig.KEY_FEC_ON, Integer.class, PrtEngineConfig.DFT_FEC_ON)));
        PrtEngineConfig.sscType = prtEngineCallback.getCfgValue(PrtEngineConfig.KEY_STREAM_CHANGE, Integer.class, PrtEngineConfig.DFT_STREAM_CHANGE);
        int sscTypeForPrt = PrtEngineConfig.sscType;
        if (sscTypeForPrt == 2) sscTypeForPrt = 0;
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "ssctype=%d", sscTypeForPrt));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "tkbt=%d", prtEngineCallback.getCfgValue(PrtEngineConfig.KEY_HEARTBEAT_TIME, Integer.class, PrtEngineConfig.DFT_HEARTBEAT_TIME)));
        sysParamsBuilder.append(JniApiImpl.seperator_and).append("rid=").append(releaseId);
        sysParamsBuilder.append(JniApiImpl.seperator_and).append("msid=").append(manualServerId);
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "rname=%s", prtEngineCallback.getAppName()));
        sysParamsBuilder.append(String.format(JniApiImpl.seperator_and + "appver=%s", prtEngineCallback.getVersionName()));

        StringBuilder channParamnsBuilder = new StringBuilder();
        channParamnsBuilder.append(String.format("th=%s", parsetacker(prtEngineCallback.getTracker(brtUrl)))); // tracker host
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "chan=%s", prtEngineCallback.getChannel(brtUrl))); // channel stream id
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "stream=%s", prtEngineCallback.getStreamId())); // stream id
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "ensm=%s", (prtEngineCallback.getDrmType() == 0) ? 0 : 1)); // plain or not
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "chid=%s", channelID)); // channel id
        channParamnsBuilder.append(JniApiImpl.seperator_and).append("cgid=").append(channelGroupId); // channel group id
        channParamnsBuilder.append(JniApiImpl.seperator_and + "chantype=1"); // channel type
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "ph=%s", servers2str(parseServers(prtEngineCallback.getSeeder(brtUrl))))); //prt host
        channParamnsBuilder.append(JniApiImpl.seperator_and + "port-b=41000"); // port begin
        channParamnsBuilder.append(JniApiImpl.seperator_and + "port-r=1000");  // port range
        // channParamnsBuilder.append(JniApiImpl.seperator_and + String.format("mask=%d", prtEngineCallback.getTransMask()));  // port range
        int mask = prtEngineCallback.getTransMask();
        channParamnsBuilder.append(JniApiImpl.seperator_and + String.format("mask=%d", prtEngineCallback.getCfgValue(KEY_TRANS_MASK, Integer.class, 0)));  // port range
        channParamnsBuilder.append(JniApiImpl.seperator_and + String.format("addi=%d", prtEngineCallback.getCfgValue(KEY_OP_CFG_ADDI, Integer.class, 20 * 1024 * 1024)));  // port range
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "chname=%s", prtEngineCallback.getChannelName()));
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "soluty=%s", prtEngineCallback.getSolutionType()));
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "soluba=%s", prtEngineCallback.getDrmType()));
        channParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "eproxy=%s", prtEngineCallback.getEproxy()));

        logger.info("spp org mask =" + mask + "sysParamsBuilder string is" + sysParamsBuilder.toString());
        logger.info("spp org mask =" + mask + "channParamnsBuilder string is" + channParamnsBuilder.toString());


        StringBuilder cfgParamnsBuilder = new StringBuilder();
        cfgParamnsBuilder.append(JniApiImpl.seperator_and + String.format("mask=%d", prtEngineCallback.getCfgValue(KEY_TRANS_MASK, Integer.class, 0)));  // port range
        cfgParamnsBuilder.append(JniApiImpl.seperator_and + String.format("addi=%d", prtEngineCallback.getCfgValue(KEY_OP_CFG_ADDI, Integer.class, 20 * 1024 * 1024)));  // port range
        cfgParamnsBuilder.append(String.format(JniApiImpl.seperator_and + "thn=%s", prtEngineCallback.getMediaCode(brtUrl)));
        prtEngineCallback.setCfgValues(cfgParamnsBuilder.toString());

        Map<String, String> otherParam = prtEngineCallback.getOtherParam();
        if (otherParam != null) {
            for (Map.Entry<String, String> entry : otherParam.entrySet()) {
                if ("loghost".equals(entry.getKey())) {
                    final String k = entry.getKey();
                    final String v = entry.getValue();

                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                String[] paras = v.split(":");
                                String ip = GetInetAddress(paras[1]);
                                String newValue = v;
                                if (!((ip == null) || (ip.length() == 0))) {
                                    newValue = paras[0] + ":" + ip + ":" + paras[2];
                                }
                                JniApiImpl.getInstance().setParam(k + "=" + newValue, newValue);
                            } catch (Exception e) {
                                JniApiImpl.getInstance().setParam(k + "=" + v, v);
                            }
                        }
                    }).start();
                    continue;
                }
                JniApiImpl.getInstance().setParam(entry.getKey() + "=" + entry.getValue(), entry.getValue());
            }
        }

        JniApiImpl.getInstance().setParam("wkm=1", null);
        currChannelIndex = JniApiImpl.getInstance().startChannel(sysParamsBuilder.toString(), channParamnsBuilder.toString(), null);
        PrtListenerManager.getInstance().registerListener(currChannelIndex, new PrtListenerManager.PrtManagerCallBack() {
            @Override
            public int getRequestId() {
                return N2JMain.DEFAULT_REQUEST_ID;
            }

            @Override
            public int getChannelId() {
                return currChannelIndex;
            }
        }, jniPrtListener);

        if (0 < currChannelIndex) {
            JniApiImpl.getInstance().initEngineProxyBuffer(currChannelIndex, 0, 0L, prtEngineCallback.getSolutionType(), prtEngineCallback.getDrmType(), prtEngineCallback.getDrmKeyLink(), 0);
            connectListener.onAuthPassed(Collections.EMPTY_MAP);
            mConnected = true;
        } else {
            connectListener.onAuthFailed(currChannelIndex, "onAuthFailed.");
            mConnected = false;
        }
        prtEngineCallback.onPrtVersion(JniApiImpl.getInstance().getVersion());
    }

    public void shutdown() {
        //todo 支持重复关闭操作
        logger.debug("shutdown");
        JniApiImpl.getInstance().closeEngineProxyBuffer(currChannelIndex);
        JniApiImpl.getInstance().stopChannel(currChannelIndex);
        PrtListenerManager.getInstance().unRegisterListener(currChannelIndex, N2JMain.DEFAULT_REQUEST_ID);
        mConnected = false;
    }

    public boolean isConnected() {
        return mConnected;
    }

    private List<String> parseServers(String string) throws Exception {
        List<String> servers = new ArrayList<>();
        if (StringUtils.isEmpty(string))
            return servers;

        String serversArr[] = string.split(",");
        for (String server : serversArr) {
            if (server.contains("*")) {
                int portPos = server.indexOf(":");
                if (portPos < 0) {
                    throw new Exception("Invalid host format:" + server);
                }
                String port = server.substring(portPos);
                String real = server.replace("*", "/").substring(0, portPos);
                SubnetUtils subnetUtils = new SubnetUtils(real);
                for (String host : subnetUtils.getInfo().getAllAddresses()) {
                    servers.add(host + port);
                }
            } else {
                servers.add(server);
            }
        }
        return servers;
    }

    private String servers2str(List<String> servers) {
        // ip1:port1,ip2:prot2,ip3:port3
        String output = "";
        if (null != servers && servers.size() > 0) {
            for (String server : servers) {
                if (StringUtils.isEmpty(output)) {
                    output += server;
                } else {
                    output += JniApiImpl.seperator_comma + server;
                }
            }
        }
        return output;
    }

    private String parsetacker(String string) throws Exception {
        String servers = "";
       /*  String regex = "\\[(.*?)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        String result = null;

        while (matcher.find()) {
            if(servers.length() != 0){
                servers +="-";
            }
            result = matcher.group(1);
            servers += servers2str(parseServers(result));
        }
        if(StringUtils.isEmpty(servers)){
            servers = servers2str(parseServers(result));
        }*/
        if (StringUtils.isEmpty(string))
            return servers;

        String serversArr[] = string.split("-");
        for (String server : serversArr) {
            if (servers.length() != 0) {
                servers += "-";
            }
            servers += servers2str(parseServers(server));
        }
        if (StringUtils.isEmpty(servers)) {
            servers = servers2str(parseServers(string));
        }
        return servers;
    }

    public int setNetworkState(NetworkState state) {
        String localIp = null;
        if (null != prtEngineCallback) {
            localIp = prtEngineCallback.getLocalIP();
        }
        if (StringUtils.isEmpty(localIp)) {
            logger.warn("localIp is empty");
            return -1;
        }
        return JniApiImpl.getInstance().setNetworkState(state, localIp);
    }

    public int setTransMask(int mask) {
        return JniApiImpl.getInstance().setTransMask(mask);
    }

    public void setLog(boolean enable, int period) {
        JniApiImpl.getInstance().setLog(enable, period);
    }

    public int flushLog() {
        return JniApiImpl.getInstance().flushLog();
    }

    public void notifyBuffering(int times, int duration) {
        JniApiImpl.getInstance().notifyBuffering(currChannelIndex, times, duration);
    }

    public void updateChannel(String key, String val) {
        JniApiImpl.getInstance().updateChannel(currChannelIndex, String.format("%s=%s", key, val));
    }

    public int getEngineChannelId() {
        return currChannelIndex;
    }
}
