package com.stream.brt.engine;

import com.stream.brt.engine.model.LiveSliceGroup;

import java.util.Map;

/**
 */
public interface BrtConnectListener {
    void onStart();
    void onAuthPassed(Map info);
    void onAuthFailed(int code, String msg);
    void onDataBegin(LiveSliceGroup sliceGroup);
    void onDataCompleted(LiveSliceGroup sliceGroup);
    void onDataDropped(LiveSliceGroup sliceGroup, String msg);
    void onInfo(int code, String msg, Map info);
    void onDisconnected(boolean serverReason, int lastMsgCode, int innerErrCode);
    void onDataReady(int chanid, int port);
}
