package com.stream.brt.engine;

import com.stream.brt.engine.model.LiveSliceGroup;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 */
public class BrtEngineChannelData {
    private int channelId;
    private String mediaCode;
    final private TreeMap<Integer, Map<String, LiveSliceGroup>> groupTreeMap = new TreeMap<>();
    private long startTime;
    private long lastUpdate;
    private int passedGroupExSeq;

    public BrtEngineChannelData() {
    }

    public boolean addGroup(LiveSliceGroup group) {
        //新数据已经是已经收过的数据，废弃
        if (group.getExSeq() <= passedGroupExSeq)
            return false;

        Map<String, LiveSliceGroup> map = groupTreeMap.get(group.getExSeq());
        if (map == null) {
            synchronized (groupTreeMap) {
                map = groupTreeMap.get(group.getExSeq());
                if (map == null) {
                    map = new HashMap<>();
                    map.put(group.getConnectionId(), group);
                    groupTreeMap.put(group.getExSeq(), map);
                }
            }
        } else {
            if (map.containsKey(group.getConnectionId())) {
                return false;
            }

            synchronized (map) {
                if (map.containsKey(group.getConnectionId())) {
                    return false;
                }
                map.put(group.getConnectionId(), group);
            }
        }

        return true;
    }

    public boolean removeGroup(LiveSliceGroup group) {
        Map<String, LiveSliceGroup> map = groupTreeMap.get(group.getExSeq());
        if (map == null) {
            return false;
        }

        if (!map.containsKey(group.getConnectionId())) {
            return false;
        }

        synchronized (map) {
            map.remove(group.getConnectionId());
        }

        if (map.isEmpty() || group.isCompleted()) {
            synchronized (groupTreeMap) {
                if (map.isEmpty() || group.isCompleted()) {
                    if (groupTreeMap.firstEntry().getKey() == group.getExSeq()) {
                        passedGroupExSeq = group.getExSeq();
                    }
                    groupTreeMap.remove(group.getExSeq());

                    return true;
                }
            }
        }

        return false;
    }

    public int getGroupCount(){
        return groupTreeMap.size();
    }

    public LiveSliceGroup getFirstGroup(){
        if(groupTreeMap.size() == 0){
            return null;
        }

        for (LiveSliceGroup sliceGroup:groupTreeMap.firstEntry().getValue().values()) {
            if (sliceGroup.isCompleted())
                return sliceGroup;
        }

        return null;
    }

    public LiveSliceGroup getFirstGroup2() {
        if(groupTreeMap.size() == 0){
            return null;
        }

        for (LiveSliceGroup sliceGroup:groupTreeMap.firstEntry().getValue().values()) {
            return sliceGroup;
        }

        return null;
    }

    public int getFirstGroupSeq(){
        if(groupTreeMap.size() == 0){
            return -1;
        }
        return groupTreeMap.firstKey();
    }
    public int getChannelId() {
        return channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public String getMediaCode() {
        return mediaCode;
    }

    public void setMediaCode(String mediaCode) {
        this.mediaCode = mediaCode;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }
}
