package com.stream.brt.engine;

import com.stream.brt.engine.model.ResendStatInfo;

import java.security.InvalidParameterException;
import java.util.*;

public class ResendUtils {
    @Deprecated
    private static byte[] resendSet2BytesV0(Set<Integer> set) {
        List<Integer> list = new ArrayList<>(set);
        Collections.sort(list);

        final int size = list.size();

        final int mode0Size = size<<1;
        final int min = list.get(0);
        final int max = list.get(size -1);

        final int n = (max - min) + 1;
        final int mode1Size = (n >>> 3) + ((n & 7) == 0 ? 0 : 1);

        final int mode = mode0Size <= mode1Size ? 0 : 1;

        byte[] bytes;
        if (mode == 0) {
            bytes = new byte[mode0Size + 8];
            for (int i=0; i<size; i++){
                int slice = list.get(i);
                int base = (i+4)<<1;
                bytes[base] = (byte)(slice & 7);
                bytes[base+1] = (byte)(slice>>>3);
            }
        } else {
            bytes = new byte[mode1Size + 8];
            Arrays.fill(bytes,(byte)0);
            for (int slice : list) {
                int offset = slice - min;
                int index = (offset >>> 3) + 8;
                int shift = offset & 7;

                bytes[index] |= 1 << shift;
            }
        }

        bytes[0] = (byte) (mode&7);
        bytes[1] = (byte) (mode>>>3);
        bytes[2] = (byte) (min&7);
        bytes[3] = (byte) (min>>>3);
        bytes[4] = (byte) (max&7);
        bytes[5] = (byte) (max>>>3);
        bytes[6] = (byte) (size&7);
        bytes[7] = (byte) (size>>>3);

        return bytes;
    }

    @Deprecated
    private static int[] bytes2ResendSetV0(byte[] bytes) throws Exception{
        if (bytes == null || bytes.length < 8)
            throw new InvalidParameterException("invalid resend data");

        final int mode = ((bytes[1]&0xff)<<3) | bytes[0];
        final int size = ((bytes[7]&0xff)<<3) | bytes[6];
        if (size > 65535 || size <=0) {
            throw new IndexOutOfBoundsException("invalid size:"+size);
        }

        final int [] resentSet = new int[size];

        if (mode == 0) {
            if (size != ((bytes.length - 8)>>>1))
                throw new InvalidParameterException("invalid resend data");

            for (int i=8, j=0; i < bytes.length; i+=2, j++) {
                resentSet[j] = ((bytes[i+1]&0xff)<<3) | bytes[i];
            }
        } else {
            final int min = ((bytes[3]&0xff)<<3) | bytes[2];
            final int max = ((bytes[5]&0xff)<<3) | bytes[4];

            for (int i=8, index = 0, cnt=0; i<bytes.length && cnt<size; i++, index++) {
                byte b = bytes[i];

                int offset = index << 3;
                if ((b & 1) == 1){
                    resentSet[cnt++] = min + offset;
                }
                if ((b & 2) == 2) {
                    resentSet[cnt++] = min + (offset | 1);
                }
                if ((b & 4) == 4) {
                    resentSet[cnt++] = min + (offset | 2);
                }
                if ((b & 8) == 8) {
                    resentSet[cnt++] = min + (offset | 3);
                }
                if ((b & 16) == 16) {
                    resentSet[cnt++] = min + (offset | 4);
                }
                if ((b & 32) == 32) {
                    resentSet[cnt++] = min + (offset | 5);
                }
                if ((b & 64) == 64) {
                    resentSet[cnt++] = min + (offset | 6);
                }
                if ((b & 128) == 128) {
                    resentSet[cnt++] = min + (offset | 7);
                }
            }

//            if (resentSet[resentSet.length-1] != max)
//                throw new InvalidParameterException("invalid resend data");
        }

        return resentSet;
    }

    /**
     * convert a set of integer into byte array, in order to saving storage space.
     * assumption:
     *            BYTES is the max size of return byte array,
     *            CNT is the count of integers in the input set, CNT is between [1 and 65536],
     *            MAX_i is the max integer in the input set,
     *            MIN_i is the min integer in the input set.
     * then:
     *            BYTES = min(CNT * 2, (MAX_i - MIN_i + 1) / 8) + 8
     *
     * for a 1310 bytes storage space, the max size of input set is 10416 = max(CNT, (MAX_i - MIN_i + 1).
     * CNT = (1310 - 8) / 2 = 651
     * (MAX_i - MIN_i + 1) = (1310 - 8) * 8 = 10416
     *
     * so, this function can convert a set with (MAX_i - MIN_i + 1) <= 10416 into a byte array that size is <= 1310.
     * specifically, MIN_i = 0, MAX_i = 10415
     * it can supports a group that has up to 10416 slices
     *
     * @param set each number in the set is a integer between [0 and 65535]
     * @return a byte array represents the input set.
     */
    public static byte[] resendSet2Bytes(Set<Integer> set) {
        List<Integer> list = new ArrayList<>(set);
        Collections.sort(list);

        final int size = list.size();

        final int mode0Size = size<<1;
        final int min = list.get(0);
        final int max = list.get(size -1);

        final int n = (max - min) + 1;
        final int mode1Size = (n >>> 3) + ((n & 7) == 0 ? 0 : 1);

        final int mode = mode0Size <= mode1Size ? 2 : 3;

        byte[] bytes;
        if (mode == 2) {
            bytes = new byte[mode0Size + 8];
            for (int i=0; i<size; i++){
                int slice = list.get(i);
                int base = (i+4)<<1;
                bytes[base] = (byte)(slice & 0xff);
                bytes[base+1] = (byte)(slice>>>0x8);
            }
        } else {
            bytes = new byte[mode1Size + 8];
            Arrays.fill(bytes,(byte)0);
            for (int slice : list) {
                int offset = slice - min;
                int index = (offset >>> 3) + 8;
                int shift = offset & 7;

                bytes[index] |= 1 << shift;
            }
        }

        bytes[0] = (byte) (mode&0xff);
        bytes[1] = (byte) (mode>>>0x8);
        bytes[2] = (byte) (min&0xff);
        bytes[3] = (byte) (min>>>0x8);
        bytes[4] = (byte) (max&0xff);
        bytes[5] = (byte) (max>>>0x8);
        bytes[6] = (byte) (size&0xff);
        bytes[7] = (byte) (size>>>0x8);

        return bytes;
    }

    /**
     * convert a byte array into integer array. this is the inverse process of resendSet2Bytes.
     * @param bytes generate by resendSet2Bytes
     * @return integer array
     * @throws Exception if the input bytes is not correctly generate by resendSet2Bytes
     */
    public static int[] bytes2ResendSet(byte[] bytes) throws Exception{
        if (bytes == null || bytes.length < 8)
            throw new InvalidParameterException("invalid resend data");

        final int mode = ((bytes[1]&0xff)<<0x8) | (bytes[0]&0xff);
        // old client version
        if (mode == 0 || mode == 1) {
            return bytes2ResendSetV0(bytes);
        }

        final int size = ((bytes[7]&0xff)<<0x8) | (bytes[6]&0xff);
        if (size > 65535 || size <=0) {
            throw new IndexOutOfBoundsException("invalid size:"+size);
        }

        final int [] resentSet = new int[size];

        if (mode == 2) {
            if (size != ((bytes.length - 8)>>>1))
                throw new InvalidParameterException("invalid resend data");

            for (int i=8, j=0; i < bytes.length; i+=2, j++) {
                resentSet[j] = ((bytes[i+1]&0xff)<<0x8) | (bytes[i]&0xff);
            }
        } else {
            final int min = ((bytes[3]&0xff)<<0x8) | (bytes[2]&0xff);
            final int max = ((bytes[5]&0xff)<<0x8) | (bytes[4]&0xff);

            for (int i=8, index = 0, cnt=0; i<bytes.length && cnt<size; i++, index++) {
                byte b = bytes[i];

                int offset = index << 3;
                if ((b & 1) == 1){
                    resentSet[cnt++] = min + offset;
                }
                if ((b & 2) == 2) {
                    resentSet[cnt++] = min + (offset | 1);
                }
                if ((b & 4) == 4) {
                    resentSet[cnt++] = min + (offset | 2);
                }
                if ((b & 8) == 8) {
                    resentSet[cnt++] = min + (offset | 3);
                }
                if ((b & 16) == 16) {
                    resentSet[cnt++] = min + (offset | 4);
                }
                if ((b & 32) == 32) {
                    resentSet[cnt++] = min + (offset | 5);
                }
                if ((b & 64) == 64) {
                    resentSet[cnt++] = min + (offset | 6);
                }
                if ((b & 128) == 128) {
                    resentSet[cnt++] = min + (offset | 7);
                }
            }

            if (resentSet[resentSet.length-1] != max)
                throw new InvalidParameterException("invalid resend data");
        }

        return resentSet;
    }

    public static byte[] resendStatInfo2Bytes(ResendStatInfo info) {
        List<Integer> list = new ArrayList<>(info.getResendSet());
        Collections.sort(list);

        final int size = list.size();

        final int mode0Size = size<<1;
        final int min = list.get(0);
        final int max = list.get(size -1);

        final int n = (max - min) + 1;
        final int mode1Size = (n >>> 3) + ((n & 7) == 0 ? 0 : 1);

        final int mode = mode0Size <= mode1Size ? 4 : 5;

        byte[] bytes;
        if (mode == 4) {
            bytes = new byte[mode0Size + 12];
            for (int i=0; i<size; i++){
                int slice = list.get(i);
                int base = (i+4)<<1;
                bytes[base] = (byte)(slice & 0xff);
                bytes[base+1] = (byte)(slice>>>0x8);
            }
        } else {
            bytes = new byte[mode1Size + 12];
            Arrays.fill(bytes,(byte)0);
            for (int slice : list) {
                int offset = slice - min;
                int index = (offset >>> 3) + 12;
                int shift = offset & 7;

                bytes[index] |= 1 << shift;
            }
        }

        bytes[0] = (byte) (mode&0xff);
        bytes[1] = (byte) (mode>>>0x8);

        bytes[2] = (byte) (min&0xff);
        bytes[3] = (byte) (min>>>0x8);

        bytes[4] = (byte) (max&0xff);
        bytes[5] = (byte) (max>>>0x8);

        bytes[6] = (byte) (size&0xff);
        bytes[7] = (byte) (size>>>0x8);

        bytes[8] = (byte) (info.getRtt()&0xff);
        bytes[9] = (byte) (info.getRtt()>>>0x8);

        bytes[10] = (byte) (info.getLostPercent()&0xff);
        bytes[11] = (byte) (info.getLostPercent()>>>0x8);

        return bytes;
    }

    public static ResendStatInfo bytes2resendStatInfo(byte[] bytes) throws Exception{
        if (bytes == null || bytes.length < 8)
            throw new InvalidParameterException("invalid resend data");

        final int mode = ((bytes[1]&0xff)<<0x8) | (bytes[0]&0xff);
        // old client version
        if (mode == 0 || mode == 1) {
            int[] ret = bytes2ResendSetV0(bytes);
            ResendStatInfo statInfo = new ResendStatInfo();
            statInfo.setResendArray(ret);
            return statInfo;
        }

        final int size = ((bytes[7]&0xff)<<0x8) | (bytes[6]&0xff);
        if (size > 65535 || size <=0) {
            throw new IndexOutOfBoundsException("invalid size:"+size);
        }

        final int [] resentArray = new int[size];

        if (mode == 2 || mode == 4) {
            int headerLen = mode == 2 ? 8 : 12;
            ResendStatInfo statInfo = new ResendStatInfo();

            if (size != ((bytes.length - headerLen)>>>1))
                throw new InvalidParameterException("invalid resend data");

            for (int i=headerLen, j=0; i < bytes.length; i+=2, j++) {
                resentArray[j] = ((bytes[i+1]&0xff)<<0x8) | (bytes[i]&0xff);
            }

            statInfo.setResendArray(resentArray);
            if (mode == 4) {
                int ttl = ((bytes[9]&0xff)<<0x8) | (bytes[8]&0xff);
                int lostPercent = ((bytes[11]&0xff)<<0x8) | (bytes[10]&0xff);
                statInfo.setRtt(ttl);
                statInfo.setLostPercent(lostPercent);
            }

            return statInfo;
        } else if (mode == 3 || mode == 5) {
            int headerLen = mode == 3 ? 8 : 12;
            ResendStatInfo statInfo = new ResendStatInfo();

            final int min = ((bytes[3]&0xff)<<0x8) | (bytes[2]&0xff);
            final int max = ((bytes[5]&0xff)<<0x8) | (bytes[4]&0xff);

            for (int i=headerLen, index = 0, cnt=0; i<bytes.length && cnt<size; i++, index++) {
                byte b = bytes[i];

                int offset = index << 3;
                if ((b & 1) == 1){
                    resentArray[cnt++] = min + offset;
                }
                if ((b & 2) == 2) {
                    resentArray[cnt++] = min + (offset | 1);
                }
                if ((b & 4) == 4) {
                    resentArray[cnt++] = min + (offset | 2);
                }
                if ((b & 8) == 8) {
                    resentArray[cnt++] = min + (offset | 3);
                }
                if ((b & 16) == 16) {
                    resentArray[cnt++] = min + (offset | 4);
                }
                if ((b & 32) == 32) {
                    resentArray[cnt++] = min + (offset | 5);
                }
                if ((b & 64) == 64) {
                    resentArray[cnt++] = min + (offset | 6);
                }
                if ((b & 128) == 128) {
                    resentArray[cnt++] = min + (offset | 7);
                }
            }

            if (resentArray[resentArray.length-1] != max)
                throw new InvalidParameterException("invalid resend data");

            statInfo.setResendArray(resentArray);
            statInfo.setResendSet(toSet(resentArray));
            if (mode == 5) {
                int ttl = ((bytes[9]&0xff)<<0x8) | (bytes[8]&0xff);
                int lostPercent = ((bytes[11]&0xff)<<0x8) | (bytes[10]&0xff);
                statInfo.setRtt(ttl);
                statInfo.setLostPercent(lostPercent);
            }

            return statInfo;
        } else {
            throw new InvalidParameterException("invalid resend data");
        }
    }

    private static Set<Integer> toSet(int [] array) {
        Set<Integer> set = new HashSet<>();
        for (int e:array) {
            set.add(e);
        }
        return set;
    }
}
