package com.stream.brt.engine;

import com.stream.brt.engine.model.BrtUrlInfo;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.List;

public class UDPDroppableSocket extends UDPSocket {
    private long received=0;
    private long ret=0;

    public UDPDroppableSocket(List<BrtUrlInfo.ServerInfo> serverInfoList, String localAddress, int bufferQueueSize, Performance performance) throws IOException {
        super(serverInfoList, localAddress, bufferQueueSize, performance);
    }

    public UDPDroppableSocket(List<BrtUrlInfo.ServerInfo> serverInfoList, String localAddress, int bufferQueueSize, int receiveBufferSize, Performance performance) throws IOException {
        super(serverInfoList, localAddress, bufferQueueSize, receiveBufferSize, performance);
    }

    @Override
    public DatagramPacket receive() throws IOException {
        DatagramPacket packet = super.receive();
        if (packet == null)
            return null;

        received++;
        if (received < 100) {
            // 开始的auth包直接返回
            ret++;
            return packet;
        }

        if (ret*100/received > BrtEngineConfig.brtDropRatio) {
            ret++;
            return packet;
        } else {
            return null;
        }
    }
}
