package com.stream.brt.engine.base;

import com.stream.brt.engine.ValueProvider;
import com.stream.brt.engine.metric.BrtMetricStorage;
import com.stream.prt.NetworkState;

import java.util.Map;

abstract public class BaseEngine {
    public abstract void initModule(String did, final String brtUrl, String platform, String appVer, BaseEngineListener playerReader, ValueProvider provider, BrtMetricStorage brtMetricStorage) throws Exception;
    public abstract void shutdown();
    public abstract boolean isRunning();
    public int setNetworkState(NetworkState state) {
        return 0;
    }
    public int setTransMask(int mask) {
        return 0;
    }

    public void setLog(boolean enable, int period) {}

    public int flushLog() {
        return 0;
    }

    public abstract void onAppEvent(int event, Map<String, Object> info);
}
