package com.stream.brt.engine.base;

import java.io.InputStream;
import java.util.Map;

/**
 *
 */
public interface BaseEngineListener {
    int WRITE_DATA_FAIL_PARTIAL = 801;
    int WRITE_DATA_FAIL_EXCEPTION = 802;
    int IP_INFO = 803;
    int KICKOFF = 0x2001;

    String KEY_EVENT_REASON = "reason";
    String APP_CHANNEL_ID = "app_channel_id";
    String KEY_EVENT_INDEX = "key_event_index";
    String KEY_CHANNEL_ID_ENGINE = "channel_id_engine";
    String KEY_IP_INFO = "ip_info";
    String KEY_EVENT_PARAM = "param";
    String KEY_EVENT_DESC = "desc";

    void onStart();

    void onAuthPassed();

    void onAuthFailed(int errorCode, String errorMsg);

    void onDataReceiveStart(InputStream inputStream);

    void onDataOverflow();

    void onDataReceiveStop(int errorCode, String errorMsg);

    void onStop(boolean serverReason, int lastMsgCode, int innerErrCode);

    void onInfo(boolean serverReason, int lastMsgCode, int innerErrCode);

    void onInfo(int what, Map<String, Object> extra);

    void onDataReady(int chanid, int port);
}
