package com.stream.brt.engine.model;

public class ResendMetricInfo {
    public int rtt;

    public int min1stLostSlices;
    public int max1stLostSlices;
    public double avg1stLostSlices;

    public int min1stLostPercent;
    public int max1stLostPercent;
    public double avg1stLostPercent;
    public int lost1stGroupCnt;

    public int min2ndLostSlices;
    public int max2ndLostSlices;
    public double avg2ndLostSlices;

    public int min2ndLostPercent;
    public int max2ndLostPercent;
    public double avg2ndLostPercent;
    public int lost2ndGroupCnt;

    public int timeoutGroupCnt;
    public int overdueGroupCnt;
    public int overCacheGroupCnt;

    public int minResendRounds;
    public int maxResendRounds;
    public double avgResendRounds;

    public int minResendSlices;
    public int maxResendSlices;
    public double avgResendSlices;

    public int resendGroupCnt;

    public int minRepeatSlices;
    public int maxRepeatSlices;
    public double avgRepeatSlices;

    public int repeatGroupCnt;

    public int groupCnt;

    public ResendMetricInfo() {
        min1stLostPercent = Integer.MAX_VALUE;
        max1stLostPercent = Integer.MIN_VALUE;
        avg1stLostPercent = 0;
        min1stLostSlices = Integer.MAX_VALUE;
        max1stLostSlices = Integer.MIN_VALUE;
        avg1stLostSlices = 0;
        lost1stGroupCnt = 0;

        min2ndLostPercent = Integer.MAX_VALUE;
        max2ndLostPercent = Integer.MIN_VALUE;
        avg2ndLostPercent = 0;
        min2ndLostSlices = Integer.MAX_VALUE;
        max2ndLostSlices = Integer.MIN_VALUE;
        avg2ndLostSlices = 0;
        lost2ndGroupCnt = 0;

        minResendRounds = Integer.MAX_VALUE;
        maxResendRounds = Integer.MIN_VALUE;
        avgResendRounds = 0;
        minResendSlices = Integer.MAX_VALUE;
        maxResendSlices = Integer.MIN_VALUE;
        avgResendSlices = 0;
        resendGroupCnt = 0;
        minRepeatSlices = Integer.MAX_VALUE;
        maxRepeatSlices = Integer.MIN_VALUE;
        avgRepeatSlices = 0;
        repeatGroupCnt = 0;
        groupCnt = 0;
        timeoutGroupCnt = 0;
        overdueGroupCnt = 0;
        overCacheGroupCnt = 0;
    }

    public void copy(ResendMetricInfo that) {
        if (that == null)
            return;

        this.rtt = that.rtt;

        this.min1stLostSlices = that.min1stLostSlices;
        this.max1stLostSlices = that.max1stLostSlices;
        this.avg1stLostSlices = that.avg1stLostSlices;

        this.min1stLostPercent = that.min1stLostPercent;
        this.max1stLostPercent = that.max1stLostPercent;
        this.avg1stLostPercent = that.avg1stLostPercent;
        this.lost1stGroupCnt = that.lost1stGroupCnt;

        this.min2ndLostSlices = that.min2ndLostSlices;
        this.max2ndLostSlices = that.max2ndLostSlices;
        this.avg2ndLostSlices = that.avg2ndLostSlices;

        this.min2ndLostPercent = that.min2ndLostPercent;
        this.max2ndLostPercent = that.max2ndLostPercent;
        this.avg2ndLostPercent = that.avg2ndLostPercent;
        this.lost2ndGroupCnt = that.lost2ndGroupCnt;

        this.timeoutGroupCnt = that.timeoutGroupCnt;
        this.overdueGroupCnt = that.overdueGroupCnt;
        this.overCacheGroupCnt = that.overCacheGroupCnt;

        this.minResendRounds = that.minResendRounds;
        this.maxResendRounds = that.maxResendRounds;
        this.avgResendRounds = that.avgResendRounds;

        this.minResendSlices = that.minResendSlices;
        this.maxResendSlices = that.maxResendSlices;
        this.avgResendSlices = that.avgResendSlices;

        this.resendGroupCnt = that.resendGroupCnt;

        this.minRepeatSlices = that.minRepeatSlices;
        this.maxRepeatSlices = that.maxRepeatSlices;
        this.avgRepeatSlices = that.avgRepeatSlices;

        this.repeatGroupCnt = that.repeatGroupCnt;

        this.groupCnt = that.groupCnt;
    }
}
