package com.stream.brt.tool;

import com.stream.brt.tool.android.SupportMenu;

/**
 * Created by Larry on 2016/11/27.
 */
public class StringTools {
    private static final String[] PADDING;
    private static final int PAD_LIMIT = 8192;
    public static final long serialVersionUID = 0;


    public static boolean isEmpty(String str) {

            return str == null || str.length() == 0;

    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        } else {
            int pads = size - str.length();
            if (pads <= 0) {
                return str;
            }
            if (pads > PAD_LIMIT) {
                return leftPad(str, size, String.valueOf(padChar));
            }
            return padding(pads, padChar).concat(str);
        }
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        } else {
            if (isEmpty(padStr)) {
                padStr = " ";
            }
            int padLen = padStr.length();
            int pads = size - str.length();
            if (pads <= 0) {
                return str;
            }
            if (padLen == 1 && pads <= PAD_LIMIT) {
                return leftPad(str, size, padStr.charAt(0));
            }
            if (pads == padLen) {
                return padStr.concat(str);
            }
            if (pads < padLen) {
                return padStr.substring(0, pads).concat(str);
            }
            char[] padding = new char[pads];
            char[] padChars = padStr.toCharArray();
            for (int i = 0; i < pads; i++) {
                padding[i] = padChars[i % padLen];
            }
            return new String(padding).concat(str);
        }
    }

    private static String padding(int repeat, char padChar) {

        String pad = PADDING[padChar];
        if (pad == null) {
            pad = String.valueOf(padChar);
        }
        while (pad.length() < repeat) {
            pad = pad.concat(pad);
        }
        PADDING[padChar] = pad;
        return pad.substring(0, repeat);
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        } else {
            int pads = size - str.length();
            if (pads <= 0) {
                return str;
            }
            if (pads > PAD_LIMIT) {
                return rightPad(str, size, String.valueOf(padChar));
            }
            return str.concat(padding(pads, padChar));
        }
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        } else {
            if (isEmpty(padStr)) {
                padStr = " ";
            }
            int padLen = padStr.length();
            int pads = size - str.length();
            if (pads <= 0) {
                return str;
            }
            if (padLen == 1 && pads <= PAD_LIMIT) {
                return rightPad(str, size, padStr.charAt(0));
            }
            if (pads == padLen) {
                return str.concat(padStr);
            }
            if (pads < padLen) {
                return str.concat(padStr.substring(0, pads));
            }
            char[] padding = new char[pads];
            char[] padChars = padStr.toCharArray();
            for (int i = 0; i < pads; i++) {
                padding[i] = padChars[i % padLen];
            }
            return str.concat(new String(padding));
        }
    }

    static {
        PADDING = new String[65535];
        PADDING[32] = "                                             ";
    }
}
