package com.stream.prt;

import java.util.Map;

public interface PrtEngineCallback {
    public String getWorkPath();

    public String getCfgFile();

    public String getLogFile();

    public void onStateInfo(Map map);

    public void onPrtVersion(String version);

    public long getConnectionId();

    public String getAccountId();

    public String getDeviceId();

    public String getTracker(String url);

    public String getSeeder(String url);

    public String getChannel(String url);

    public String getStreamId();

    public String getToken(String url);

    public String getLocalIP();

    public boolean isAdminMode();

    NetworkState getNetworkState();

    public int getTransMask();

    //Class<T> String.class Integer.class Boolean.class Byte.class ...
    public <T> T getCfgValue(String cfgKey, Class<T> type, T defaultVal);

    public void setCfgValues(String value);

    public String getChannelId();

    public String getMediaCode(String url);

    public int getPlayerCacheTime();

    public Map<String, String> getOtherParam();

    public String getChannelName();

    public String getAppName();

    public String getVersionName();

    public int getSolutionType();

    public int getDrmType();

    public String getDrmKeyLink();

    public String getEproxy();

    public int getProxyPushMode();

    public int isAbr();

    public int getDelayLive();

    public String getPipe();

    public String getStreamKey();

    public Map<String, String> getExpandChannelParam();
}
