/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.cache.CachedResponse;
import graphql.kickstart.servlet.cache.GraphQLResponseCacheManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheReader.class);

    public boolean responseFromCache(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response, GraphQLResponseCacheManager cacheManager) throws IOException {
        try {
            CachedResponse cachedResponse = cacheManager.get(request, invocationInput);
            if (cachedResponse != null) {
                this.write(response, cachedResponse);
                return true;
            }
        }
        catch (Exception t) {
            log.warn("Ignore read from cache, unexpected error happened", (Throwable)t);
        }
        return false;
    }

    private void write(HttpServletResponse response, CachedResponse cachedResponse) throws IOException {
        if (cachedResponse.isError()) {
            response.sendError(cachedResponse.getErrorStatusCode().intValue(), cachedResponse.getErrorMessage());
        } else {
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(200);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentLength(cachedResponse.getContentBytes().length);
            response.getOutputStream().write(cachedResponse.getContentBytes());
        }
    }
}

