/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring;

import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.config.GraphQLSchemaProvider;
import graphql.kickstart.execution.context.GraphQLContext;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.spring.GraphQLSpringContextBuilder;
import graphql.kickstart.spring.GraphQLSpringInvocationInputFactory;
import graphql.kickstart.spring.GraphQLSpringRootObjectBuilder;
import graphql.kickstart.spring.GraphQLSpringServerWebExchangeContext;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.web.server.ServerWebExchange;

public class DefaultGraphQLSpringInvocationInputFactory
implements GraphQLSpringInvocationInputFactory {
    private final Supplier<GraphQLSchemaProvider> schemaProviderSupplier;
    private Supplier<GraphQLSpringContextBuilder> contextBuilderSupplier = () -> GraphQLSpringServerWebExchangeContext::new;
    private Supplier<GraphQLSpringRootObjectBuilder> rootObjectBuilderSupplier = () -> serverWebExchange -> new Object();

    public DefaultGraphQLSpringInvocationInputFactory(GraphQLSchemaProvider schemaProvider, GraphQLSpringContextBuilder contextBuilder, GraphQLSpringRootObjectBuilder rootObjectBuilder) {
        Objects.requireNonNull(schemaProvider, "GraphQLSchemaProvider is required");
        this.schemaProviderSupplier = () -> schemaProvider;
        if (contextBuilder != null) {
            this.contextBuilderSupplier = () -> contextBuilder;
        }
        if (rootObjectBuilder != null) {
            this.rootObjectBuilderSupplier = () -> rootObjectBuilder;
        }
    }

    public DefaultGraphQLSpringInvocationInputFactory(Supplier<GraphQLSchemaProvider> schemaProviderSupplier, Supplier<GraphQLSpringContextBuilder> contextBuilderSupplier, Supplier<GraphQLSpringRootObjectBuilder> rootObjectBuilderSupplier) {
        this.schemaProviderSupplier = Objects.requireNonNull(schemaProviderSupplier, "GraphQLSchemaProvider is required");
        if (contextBuilderSupplier != null) {
            this.contextBuilderSupplier = contextBuilderSupplier;
        }
        if (rootObjectBuilderSupplier != null) {
            this.rootObjectBuilderSupplier = rootObjectBuilderSupplier;
        }
    }

    @Override
    public GraphQLSingleInvocationInput create(GraphQLRequest graphQLRequest, ServerWebExchange serverWebExchange) {
        return new GraphQLSingleInvocationInput(graphQLRequest, this.schemaProviderSupplier.get().getSchema(), (GraphQLContext)this.contextBuilderSupplier.get().build(serverWebExchange), this.rootObjectBuilderSupplier.get().build(serverWebExchange));
    }

    @Override
    public GraphQLBatchedInvocationInput create(Collection<GraphQLRequest> graphQLRequests, ServerWebExchange serverWebExchange) {
        throw new UnsupportedOperationException("Batch queries not suppoprted yet");
    }

    @Generated
    protected Supplier<GraphQLSchemaProvider> getSchemaProviderSupplier() {
        return this.schemaProviderSupplier;
    }

    @Generated
    protected Supplier<GraphQLSpringContextBuilder> getContextBuilderSupplier() {
        return this.contextBuilderSupplier;
    }

    @Generated
    protected Supplier<GraphQLSpringRootObjectBuilder> getRootObjectBuilderSupplier() {
        return this.rootObjectBuilderSupplier;
    }
}

