/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ReflectionUtils;

public class GraphQLExtendedScalarsInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(@NonNull GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        Set<String> enabledExtendedScalars = this.getEnabledExtendedScalars(applicationContext);
        HashSet<String> validScalarNames = new HashSet<String>();
        ReflectionUtils.doWithFields(ExtendedScalars.class, scalarField -> {
            if (Modifier.isPublic(scalarField.getModifiers()) && Modifier.isStatic(scalarField.getModifiers()) && scalarField.getType().equals(GraphQLScalarType.class)) {
                GraphQLScalarType graphQLScalarType = (GraphQLScalarType)scalarField.get(null);
                if (enabledExtendedScalars.contains(graphQLScalarType.getName())) {
                    applicationContext.registerBean(graphQLScalarType.getName(), GraphQLScalarType.class, () -> graphQLScalarType, new BeanDefinitionCustomizer[0]);
                }
                validScalarNames.add(graphQLScalarType.getName());
            }
        });
        this.verifyEnabledScalars(enabledExtendedScalars, validScalarNames);
    }

    private void verifyEnabledScalars(Collection<String> enabledExtendedScalars, Collection<String> validScalarNames) {
        HashSet<String> invalidScalarNames = new HashSet<String>(enabledExtendedScalars);
        invalidScalarNames.removeAll(validScalarNames);
        if (!invalidScalarNames.isEmpty()) {
            throw new ApplicationContextException(String.format("Invalid extended scalar name(s) found: %s. Valid names are: %s.", this.joinNames(invalidScalarNames), this.joinNames(validScalarNames)));
        }
    }

    private String joinNames(Collection<String> names) {
        return names.stream().sorted().collect(Collectors.joining(", "));
    }

    private Set<String> getEnabledExtendedScalars(GenericApplicationContext applicationContext) {
        return ((Collection)applicationContext.getEnvironment().getProperty("graphql.extended-scalars", Collection.class, Collections.emptySet())).stream().map(String::valueOf).collect(Collectors.toSet());
    }

    @Generated
    public GraphQLExtendedScalarsInitializer() {
    }
}

