/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.voyager;

import graphql.kickstart.autoconfigure.editor.voyager.VoyagerIndexHtmlTemplate;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Controller
public class ReactiveVoyagerController {
    private final VoyagerIndexHtmlTemplate indexTemplate;

    @GetMapping(path={"${graphql.voyager.mapping:/voyager}"})
    public Mono<ResponseEntity<String>> voyager(ServerWebExchange exchange, @PathVariable Map<String, String> params) {
        Mono csrfToken = (Mono)exchange.getAttribute(CsrfToken.class.getName());
        return csrfToken != null ? csrfToken.map(csrf -> this.fillTemplate((CsrfToken)csrf, params)) : Mono.just(this.fillTemplate(null, params));
    }

    private ResponseEntity<String> fillTemplate(CsrfToken csrf, Map<String, String> params) {
        try {
            String indexHtmlContent = this.indexTemplate.fillIndexTemplate("", csrf, params);
            return ResponseEntity.ok().contentType(MediaType.valueOf((String)"text/html; charset=UTF-8")).body((Object)indexHtmlContent);
        }
        catch (IOException e) {
            return ResponseEntity.status((int)500).body(null);
        }
    }

    @Generated
    public ReactiveVoyagerController(VoyagerIndexHtmlTemplate indexTemplate) {
        this.indexTemplate = indexTemplate;
    }
}

