/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.voyager;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.autoconfigure.editor.voyager.VoyagerPropertiesConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestParam;

public class VoyagerIndexHtmlTemplate {
    private static final String CDNJS_CLOUDFLARE_COM_AJAX_LIBS = "//cdnjs.cloudflare.com/ajax/libs/";
    private static final String CDN_JSDELIVR_NET_NPM = "//cdn.jsdelivr.net/npm/";
    private static final String VOYAGER = "graphql-voyager";
    private static final String FAVICON_APIS_GURU = "//apis.guru/graphql-voyager/icons/favicon-16x16.png";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final VoyagerPropertiesConfiguration voyagerConfiguration;

    public String fillIndexTemplate(String contextPath, Object csrf, Map<String, String> params) throws IOException {
        String template = StreamUtils.copyToString((InputStream)new ClassPathResource("templates/voyager.html").getInputStream(), (Charset)Charset.defaultCharset());
        String basePath = this.voyagerConfiguration.getBasePath();
        String voyagerCdnVersion = this.voyagerConfiguration.getCdn().getVersion();
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (csrf != null) {
            replacements.put("_csrf", this.objectMapper.writeValueAsString(csrf));
        } else {
            replacements.put("_csrf", "null");
        }
        replacements.put("graphqlEndpoint", this.constructGraphQlEndpoint(contextPath, params));
        replacements.put("pageTitle", this.voyagerConfiguration.getPageTitle());
        replacements.put("pageFavicon", this.getResourceUrl(basePath, "favicon.ico", FAVICON_APIS_GURU));
        replacements.put("es6PromiseJsUrl", this.getResourceUrl(basePath, "es6-promise.auto.min.js", this.joinCdnjsPath("es6-promise", "4.1.1", "es6-promise.auto.min.js")));
        replacements.put("fetchJsUrl", this.getResourceUrl(basePath, "fetch.min.js", this.joinCdnjsPath("fetch", "2.0.4", "fetch.min.js")));
        replacements.put("reactJsUrl", this.getResourceUrl(basePath, "react.min.js", this.joinCdnjsPath("react", "16.8.3", "umd/react.production.min.js")));
        replacements.put("reactDomJsUrl", this.getResourceUrl(basePath, "react-dom.min.js", this.joinCdnjsPath("react-dom", "16.8.3", "umd/react-dom.production.min.js")));
        replacements.put("voyagerCssUrl", this.getResourceUrl(basePath, "voyager.css", this.joinJsDelivrPath(voyagerCdnVersion, "dist/voyager.css")));
        replacements.put("voyagerJsUrl", this.getResourceUrl(basePath, "voyager.min.js", this.joinJsDelivrPath(voyagerCdnVersion, "dist/voyager.min.js")));
        replacements.put("voyagerWorkerJsUrl", this.getResourceUrl(basePath, "voyager.worker.js", this.joinJsDelivrPath(voyagerCdnVersion, "dist/voyager.worker.min.js")));
        replacements.put("contextPath", contextPath);
        replacements.put("voyagerDisplayOptionsSkipRelay", Boolean.toString(this.voyagerConfiguration.getDisplayOptions().isSkipRelay()));
        replacements.put("voyagerDisplayOptionsSkipDeprecated", Boolean.toString(this.voyagerConfiguration.getDisplayOptions().isSkipDeprecated()));
        replacements.put("voyagerDisplayOptionsRootType", this.voyagerConfiguration.getDisplayOptions().getRootType());
        replacements.put("voyagerDisplayOptionsSortByAlphabet", Boolean.toString(this.voyagerConfiguration.getDisplayOptions().isSortByAlphabet()));
        replacements.put("voyagerDisplayOptionsShowLeafFields", Boolean.toString(this.voyagerConfiguration.getDisplayOptions().isShowLeafFields()));
        replacements.put("voyagerDisplayOptionsHideRoot", Boolean.toString(this.voyagerConfiguration.getDisplayOptions().isHideRoot()));
        replacements.put("voyagerHideDocs", Boolean.toString(this.voyagerConfiguration.isHideDocs()));
        replacements.put("voyagerHideSettings", Boolean.toString(this.voyagerConfiguration.isHideSettings()));
        return StringSubstitutor.replace((Object)template, replacements);
    }

    private String constructGraphQlEndpoint(String contextPath, @RequestParam Map<String, String> params) {
        String endpoint = this.voyagerConfiguration.getEndpoint();
        for (Map.Entry<String, String> param : params.entrySet()) {
            endpoint = endpoint.replaceAll("\\{" + Pattern.quote(param.getKey()) + "}", param.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)contextPath) && !endpoint.startsWith(contextPath)) {
            return contextPath + endpoint;
        }
        return endpoint;
    }

    private String getResourceUrl(String staticBasePath, String staticFileName, String cdnUrl) {
        if (this.voyagerConfiguration.getCdn().isEnabled() && StringUtils.isNotBlank((CharSequence)cdnUrl)) {
            return cdnUrl;
        }
        return this.joinStaticPath(staticBasePath, staticFileName);
    }

    private String joinStaticPath(String staticBasePath, String staticFileName) {
        return staticBasePath + "vendor/voyager/" + staticFileName;
    }

    private String joinCdnjsPath(String library, String cdnVersion, String cdnFileName) {
        return CDNJS_CLOUDFLARE_COM_AJAX_LIBS + library + "/" + cdnVersion + "/" + cdnFileName;
    }

    private String joinJsDelivrPath(String cdnVersion, String cdnFileName) {
        return "//cdn.jsdelivr.net/npm/graphql-voyager@" + cdnVersion + "/" + cdnFileName;
    }

    @Generated
    public VoyagerIndexHtmlTemplate(VoyagerPropertiesConfiguration voyagerConfiguration) {
        this.voyagerConfiguration = voyagerConfiguration;
    }
}

