/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.config.config;

import com.gs.common.config.config.AbstractConfigTools;
import com.gs.common.config.config.ConfigValueTools;
import com.gs.common.config.config.listener.IConfigChangeListener;
import com.gs.common.config.configcenter.ConfigCenterService;
import com.gs.common.config.configcenter.common.ConfigOverrideTools;
import com.gs.common.config.file.monitor.FileContentListener;
import com.gs.common.config.file.monitor.PathFileMonitor;
import com.gs.common.config.model.ConfigToolConfigDTO;
import com.gs.common.config.model.LocalConfigDTO;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRouteTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRouteTools.class);

    public void loadConfig(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        long start = System.currentTimeMillis();
        this.initParameter(configObj);
        switch (configObj.getRunMode()) {
            case 1: {
                this.localStart(configObj, listener);
                break;
            }
            case 2: {
                this.configCenterStart(configObj, listener);
                break;
            }
            case 3: {
                this.localStart(configObj, listener);
                this.configCenterStart(configObj, listener);
                break;
            }
        }
        logger.info("loading finished,runMode:[{}] time consume:[{}]s", (Object)configObj.getRunMode(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private void initParameter(ConfigToolConfigDTO configObj) {
        ConfigOverrideTools.initLevels(configObj.getProject(), configObj.getModule(), configObj.getEnv(), configObj.getRegion());
        ConfigValueTools.extSet = new HashSet<String>(configObj.getPropertiesExtension());
    }

    private void localStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        LocalConfigDTO localInitInfo = configObj.getLocalConfig();
        new PathFileMonitor(localInitInfo.getRefreshInterval()).monitorPath(AbstractConfigTools.replaceDirectoryPath(localInitInfo.getPath()), null, null, new FileContentListener(false, listener), localInitInfo.getRecursive()).start();
    }

    private void configCenterStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        new ConfigCenterService(configObj.getConfigCenterConfig()).load(listener);
    }
}

