/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.web.diagnosis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.gs.common.base.sys.SystemTools;
import com.gs.common.web.http.HttpTools;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DiagnosisController {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisController.class);
    @Autowired(required=false)
    private BuildProperties buildProperties;

    @ResponseBody
    @RequestMapping(value={"/api/ping2"})
    public Map<String, String> ping(HttpServletRequest httpRequest, HttpServletResponse httpResponse, @RequestParam(required=false, defaultValue="0") int version) {
        String clientIp = HttpTools.getRemoteHost(httpRequest);
        LinkedHashMap response = Maps.newLinkedHashMap();
        response.put("server", SystemTools.getHostnameMD5());
        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        response.put("serverTimestamp", "" + dateNow.getTime());
        response.put("serverTime", simpleDateFormat.format(dateNow));
        response.put("clientIp", clientIp);
        if (version == 1) {
            response.put("version", "UNKNOWN VERSION");
            if (this.buildProperties != null) {
                this.buildProperties.forEach(e -> {
                    if (!Strings.isNullOrEmpty((String)e.getKey())) {
                        response.put(e.getKey(), e.getValue());
                    }
                });
            }
        }
        return response;
    }
}

