/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.base.encrypt;

import com.gs.common.base.encrypt.Base64Utils;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LNE = 128;

    public static byte[] initkey(String keyString) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyString.getBytes("UTF-8"));
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static String generateKey(String keyString) {
        try {
            return Base64Utils.encodeURLSafe(AESUtils.initkey(keyString));
        }
        catch (Exception e) {
            logger.error("generateKey failed.", (Throwable)e);
            return "";
        }
    }

    public static byte[] decodeKey(String base64String) {
        return Base64Utils.decodeAsByteArray(base64String);
    }

    public static Key codeToKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        return secretKey;
    }

    public static String decrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, k);
        return new String(cipher.doFinal(data), "UTF-8");
    }

    public static String decrypt(String data, String key) throws Exception {
        return AESUtils.decrypt(Base64Utils.decodeAsByteArray(data), Base64Utils.decodeAsByteArray(key));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encrypt(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = Base64Utils.decodeAsByteArray(key);
        return Base64Utils.encodeURLSafe(AESUtils.encrypt(dataBytes, keyBytes));
    }

    public static String encrypt2(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = AESUtils.initkey(key);
        return Base64Utils.encodeURLSafe(AESUtils.encrypt(dataBytes, keyBytes));
    }

    public static String decrypt2(String data, String key) throws Exception {
        byte[] dataBytes = Base64Utils.decodeAsByteArray(data);
        byte[] keyBytes = AESUtils.initkey(key);
        return AESUtils.decrypt(dataBytes, keyBytes);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

