/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.base.encrypt;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static final Logger logger = LoggerFactory.getLogger(Base64Utils.class);

    public static String encode(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static String encodeURLSafe(String data) {
        try {
            return Base64.encodeBase64URLSafeString((byte[])data.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Base64Utils.encodeURLSafe:{}", (Object)data, (Object)e);
            return "";
        }
    }

    public static String encodeURLSafe(byte[] data) {
        return Base64.encodeBase64URLSafeString((byte[])data);
    }

    public static String decode(String data) {
        try {
            return new String(Base64.decodeBase64((String)data), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Base64Utils.decode:{}", (Object)data, (Object)e);
            return "";
        }
    }

    public static byte[] decodeAsByteArray(String data) {
        return Base64.decodeBase64((String)data);
    }
}

