/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.config.config;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gs.common.config.config.AbstractConfigData;
import com.gs.common.config.config.listener.IConfigChangeListener;
import com.gs.common.config.config.loader.properties.PropertiesLoader;
import com.gs.common.config.configcenter.common.ConfigOverrideTools;
import com.gs.common.config.model.ConfigChangeListenerDTO;
import com.gs.common.config.model.ConfigValueDTO;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValueTools
extends AbstractConfigData {
    private static final Logger logger = LoggerFactory.getLogger(ConfigValueTools.class);
    public static Map<String, ConfigChangeListenerDTO> listenerMap = Maps.newHashMap();
    public static Set<String> extSet = Sets.newHashSet();

    public static void registerListener(Map<String, Integer> fileMap, IConfigChangeListener listener) {
        fileMap.forEach((k, v) -> ConfigValueTools.registerListener(k, v, listener));
    }

    public static void registerListener(String fileName, int weight, IConfigChangeListener listener) {
        ConfigChangeListenerDTO listenerDTO = listenerMap.get(fileName);
        if (Objects.isNull(listenerDTO)) {
            listenerDTO = new ConfigChangeListenerDTO(fileName, weight, listener);
        } else {
            int oldWeight = listenerDTO.getWeight();
            listenerDTO.setWeight(weight);
            listenerDTO.setListener(listener);
            logger.info("[{}] register listener change. oldWeight[{}]->newWeight[{}]", new Object[]{fileName, oldWeight, weight});
        }
        listenerMap.put(fileName, listenerDTO);
    }

    public static void update(String dataId, String content) {
        if (Strings.isNullOrEmpty((String)content)) {
            return;
        }
        ConfigValueTools.updateValue(dataId, ConfigOverrideTools.getConfigFileNameFromDataId(dataId, ConfigValueTools.getListener(dataId).getWeight()), content);
        if (ConfigValueTools.isProperties(dataId)) {
            ConfigValueTools.loader(dataId, content);
        }
    }

    private static void loader(String dataId, String content) {
        Map<String, String> valueMap = PropertiesLoader.loader(content);
        valueMap.forEach((k, v) -> ConfigValueTools.updateValue(dataId, k, v));
    }

    private static void updateValue(String dataId, String key, String value) {
        ConfigChangeListenerDTO listenerDTO = ConfigValueTools.getListener(dataId);
        if (Objects.isNull(listenerDTO)) {
            logger.error("Config listener Missing ,dataId[{}]", (Object)dataId);
            return;
        }
        int weight = listenerDTO.getWeight();
        ConfigValueDTO oldValue = null;
        ConfigValueDTO newValue = new ConfigValueDTO(value, weight);
        boolean valueChanged = true;
        if (configMap.containsKey(key)) {
            oldValue = (ConfigValueDTO)configMap.get(key);
            if (ConfigValueDTO.compare(oldValue, newValue) >= 0) {
                valueChanged = false;
            }
        } else {
            oldValue = ConfigValueDTO.emptyValue();
        }
        if (valueChanged) {
            configMap.put(key, newValue);
            IConfigChangeListener listener = listenerDTO.getListener();
            if (Objects.nonNull(listener)) {
                listener.event(dataId, key, oldValue.getValue(), value);
            }
            logger.info("[{}],property modify:key[{}] value[{}]->[{}] level[{}]->[{}]", new Object[]{dataId, key, oldValue.getValue(), value, oldValue.getWeight(), weight});
        }
    }

    private static boolean isProperties(String dataId) {
        String suffix = dataId.substring(dataId.lastIndexOf(".") + 1);
        return extSet.contains(suffix);
    }

    public static ConfigChangeListenerDTO getListener(String fileName) {
        return listenerMap.get(fileName);
    }
}

