/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.base.limiter;

import com.google.common.base.Strings;
import com.gs.common.base.limiter.AbstractRateLimiter;
import java.util.concurrent.atomic.AtomicLong;

public class RateBlockLimiter
extends AbstractRateLimiter<String, AtomicLong> {
    public RateBlockLimiter(String limiterName, int timeUnitSeconds) {
        super(limiterName, timeUnitSeconds, 1);
    }

    @Override
    public long incAndGetCount(String key, AtomicLong value) {
        if (value == null) {
            value = new AtomicLong(0L);
        }
        long count = value.incrementAndGet();
        this.limitCache.put((Object)key, (Object)value);
        return count;
    }

    @Override
    public String getKey(String key) {
        return Strings.nullToEmpty((String)key);
    }

    @Override
    public long getCount(AtomicLong count) {
        if (count == null) {
            return 0L;
        }
        return count.get();
    }

    @Override
    public boolean isOutOfLimit(String key) {
        return super.isOutOfLimit(key, true);
    }
}

