/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.config.model;

import java.util.Objects;

public class ConfigValueDTO {
    private String value;
    private long timestamp;
    private int weight;

    public ConfigValueDTO(String value, int weight) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.weight = weight;
    }

    public ConfigValueDTO(String value) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.weight = -1;
    }

    public static ConfigValueDTO valueOf(String value) {
        return new ConfigValueDTO(value);
    }

    public static ConfigValueDTO emptyValue() {
        return new ConfigValueDTO(null, Integer.MIN_VALUE);
    }

    public boolean contentEquals(ConfigValueDTO that) {
        if (Objects.isNull(this.value)) {
            return Objects.isNull(that) || Objects.isNull(that.value);
        }
        return this.value.contentEquals(that.value);
    }

    public boolean contentEquals(String value) {
        if (Objects.isNull(this.value)) {
            return Objects.isNull(value);
        }
        return this.value.contentEquals(value);
    }

    public static int compare(ConfigValueDTO x, ConfigValueDTO y) {
        if (x.getWeight() < y.getWeight()) {
            return -1;
        }
        if (x.getWeight() > y.getWeight()) {
            return 1;
        }
        if (x.contentEquals(y)) {
            return 0;
        }
        return -1;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

