/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.config.file.monitor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.gs.common.config.config.loader.json.JsonSerialize;
import com.gs.common.config.file.monitor.FileChangeListenerAdaptor;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonChangeListener
extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(JsonChangeListener.class);
    private Map<String, TypeReference> fileType = Maps.newHashMap();
    private Map<String, Object> fileValue = Maps.newHashMap();

    public JsonChangeListener(boolean backupAfterProcess, Map<String, TypeReference> fileType, Map<String, Object> fileValue) {
        super(backupAfterProcess);
        this.fileType = fileType;
        this.fileValue = fileValue;
    }

    @Override
    public void onFileCreate(File file) {
        this.loadJson(file);
    }

    @Override
    public void onFileChange(File file) {
        this.loadJson(file);
    }

    public void onFileDelete(File file) {
    }

    public void loadJson(File file) {
        String fn = FilenameUtils.getName((String)file.getName());
        if (!this.fileType.containsKey(fn)) {
            logger.info("File[{}] not listener");
            return;
        }
        TypeReference typeReference = this.fileType.get(fn);
        Object v = JsonSerialize.loadJson(file, typeReference);
        if (v != null) {
            this.fileValue.put(fn, v);
            logger.info("Load json file[{}]", (Object)file.getAbsolutePath());
        } else {
            logger.info("Load json file[{}] may be error", (Object)file.getAbsolutePath());
        }
    }
}

