/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.ipdb.filemanager;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.gs.common.ipdb.api.geoip.EGeoIPDBType;
import com.gs.common.ipdb.api.geoip.GeoIPConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiledTools {
    private static Logger logger = LoggerFactory.getLogger(FiledTools.class);

    public static void download(String urlPath, String filename) {
        try {
            logger.info("Start download file[{}] from[{}]", (Object)filename, (Object)urlPath);
            URL url = new URL(urlPath);
            ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(filename);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            logger.info("Finish download file[{}] ", (Object)filename);
        }
        catch (MalformedURLException e) {
            logger.error("Download Exception file[{}]", (Object)filename, (Object)e);
        }
        catch (IOException e) {
            logger.error("Download IOException file[{}]", (Object)filename, (Object)e);
        }
    }

    public static void uncompressTarGzip(String sourcePath, String targetPath, String suffix) {
        logger.info("Start uncompress file[{}] to[{}]", (Object)sourcePath, (Object)targetPath);
        File sourceFile = new File(sourcePath);
        File targetFolder = new File(targetPath);
        try (TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(sourceFile)));){
            TarArchiveEntry entry;
            while ((entry = fin.getNextTarEntry()) != null) {
                String filename;
                String fileSuffix;
                if (entry.isDirectory() || !suffix.contains(fileSuffix = Files.getFileExtension((String)(filename = FilenameUtils.getName((String)entry.getName()))))) continue;
                String tmpFilename = GeoIPConfig.getFilenameUpgrade(filename);
                File currentFile = new File(targetFolder, tmpFilename);
                if (!currentFile.exists()) {
                    currentFile.createNewFile();
                }
                logger.info("Uncompress file[{}] ", (Object)tmpFilename);
                FileOutputStream fout = new FileOutputStream(currentFile);
                IOUtils.copy((InputStream)fin, (OutputStream)fout);
                fout.close();
            }
            logger.info("Finish uncompress file[{}] to[{}]", (Object)sourcePath, (Object)targetPath);
        }
        catch (IOException e) {
            logger.error("uncompressTarGzip IOException file[{}]", (Object)sourcePath, (Object)e);
        }
    }

    public static void move(String from, String to) {
        try {
            File fromFile = new File(from);
            File toFile = new File(to);
            FileUtils.copyFile((File)fromFile, (File)toFile, (boolean)true);
            if (fromFile.exists()) {
                fromFile.delete();
            }
            logger.info("Move success.from[{}] to[{}]", (Object)from, (Object)to);
        }
        catch (IOException e) {
            logger.info("Move failed.from[{}] to[{}]", (Object)from, (Object)to);
        }
    }

    public static boolean isNeedUpdate(EGeoIPDBType type) {
        String filename = GeoIPConfig.dbFilename(type);
        File file = FileUtils.getFile((String[])new String[]{filename});
        if (!file.exists()) {
            logger.info("File [{}] not exist,need update", (Object)filename);
            return true;
        }
        long duration = GeoIPConfig.updateDuration();
        long lastModify = file.lastModified();
        if (System.currentTimeMillis() - lastModify > TimeUnit.MINUTES.toMillis(duration)) {
            logger.info("File [{}] need update,last modify time[{}]", (Object)filename, (Object)DateFormat.getDateTimeInstance(0, 0).format(new Date(lastModify)));
            return true;
        }
        return false;
    }

    public static boolean mkdirsIfNotExist(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        try {
            File rootPath = new File(path);
            if (!rootPath.exists()) {
                rootPath.mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            logger.error("mkdir[{}] exception", (Object)path, (Object)e);
            return false;
        }
    }
}

