/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.web.statistics.scheduler;

import com.google.common.base.Strings;
import com.gs.common.base.stat.StatTools;
import com.gs.common.base.statistics.ApiQpsStatisticsTools;
import com.gs.common.base.statistics.ApiRequestInfo;
import com.gs.common.base.statistics.CountStatisticsTools2;
import com.gs.common.base.statistics.QpsItem;
import com.gs.common.base.statistics.ServiceStatisticItem;
import com.gs.common.base.statistics.StatTimeItem;
import com.gs.common.base.statistics.TimeStatisticsTools2;
import com.gs.common.base.type.CollectionUtils;
import com.gs.common.config.config.ConfigTools3;
import com.gs.common.web.statistics.scheduler.WebApiStatisticsReportTools;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WebApiStatisticsScheduler {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsScheduler.class);
    static long lastReportTS = 0L;

    @Scheduled(fixedRate=3000L)
    public void statisticsScheduler() {
        long cycle = ConfigTools3.getLong("api.statistics.cycle", 60000L);
        if (System.currentTimeMillis() - lastReportTS > cycle) {
            this.reportAndPrint();
            lastReportTS = System.currentTimeMillis();
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void localStatisticsScheduler() {
        String msg = StatTools.dumpMutilline(false);
        if (!Strings.isNullOrEmpty((String)msg)) {
            logger.info("LOCAL-STAT:{}", (Object)msg);
        }
    }

    public void reportAndPrint() {
        if (ConfigTools3.getBoolean("statistics.out.log", true)) {
            boolean printPretty = ConfigTools3.getBoolean("statistics.out.pretty", true);
            String countStats = CountStatisticsTools2.dump(printPretty);
            String timeStats = TimeStatisticsTools2.dump(printPretty);
            if (!Strings.isNullOrEmpty((String)countStats) || !Strings.isNullOrEmpty((String)timeStats)) {
                logger.info("CountStats:{} TimeStats:{}", (Object)countStats, (Object)timeStats);
            }
        }
        if (ConfigTools3.getBoolean("statistics.report", true)) {
            this.reportCount2Metric();
            this.reportTime2Metric();
        }
        if (ConfigTools3.getBoolean("statistics.qps.report", true)) {
            this.reportQpiQps2Metric();
        }
        CountStatisticsTools2.clear();
        TimeStatisticsTools2.clear();
    }

    private void reportTime2Metric() {
        Map<String, StatTimeItem> countMap = TimeStatisticsTools2.getTimeStatMap();
        countMap.forEach((k, v) -> {
            WebApiStatisticsReportTools.reportTimeConsumed(v.getKey(), v.getCount(), v.avg());
            ConfigTools3.getAsList("statistics.level").forEach(s -> WebApiStatisticsReportTools.reportTimeConsumedByStatus(s, v));
        });
    }

    private void reportCount2Metric() {
        Map<String, Map<String, Long>> countMap = CountStatisticsTools2.getCountData();
        countMap.forEach((k, v) -> v.forEach((k1, v1) -> WebApiStatisticsReportTools.reportCount(String.format("%s-%s", k, k1), v1)));
    }

    private void reportQpiQps2Metric() {
        Map<ServiceStatisticItem, QpsItem> visit;
        List<ApiRequestInfo> requests = ApiQpsStatisticsTools.getRequestSummary();
        if (!CollectionUtils.isNullOrEmpty(requests)) {
            for (ApiRequestInfo request : requests) {
                ApiQpsStatisticsTools.addVisits(request);
            }
        }
        if (!CollectionUtils.isNullOrEmpty(visit = ApiQpsStatisticsTools.getAndResetVisit())) {
            WebApiStatisticsReportTools.reportQps(visit);
        }
    }
}

