/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.web.webapi.processor;

import com.gs.common.base.exception.ApiException;
import com.gs.common.web.http.HttpTools;
import com.gs.common.web.webapi.annotation.WebApiCheckServiceToken;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Aspect
@Service
public class WebApiCheckServiceTokenInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCheckServiceTokenInterceptor.class);

    @Pointcut(value="@annotation(common.web.tools.webapi.annotation.WebApiCheckServiceToken)")
    public void webApiCheckServiceToken() {
    }

    @Before(value="common.web.tools.webapi.processor.WebApiCheckServiceTokenInterceptor.webApiCheckServiceToken()&&@annotation(wapiCST)")
    public void webApiCheckServiceTokenProcessor(JoinPoint jp, WebApiCheckServiceToken wapiCST) throws ApiException {
        HttpServletRequest request = (HttpServletRequest)jp.getArgs()[0];
        Long appVer = HttpTools.getLongParameter(request, "appVer");
        if (appVer == null) {
            throw new ApiException(-9992, "App version is empty.");
        }
        if (appVer <= (long)wapiCST.minSupportAppVer()) {
            logger.info("Version not support Service token.");
            return;
        }
    }
}

