/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.base.token;

import com.gs.common.base.token.TokenValueObject;
import com.gs.common.base.token.serializer.ITokenSerializer;
import com.gs.common.base.token.serializer.TokenJsonSerializer;
import java.util.Objects;

public class TokenObject
extends TokenValueObject {
    private static final String TOKEN_FIELD_VERSION = "V";
    private static final String TOKEN_FIELD_CREATE_TS = "CTS";
    private static final String TOKEN_FIELD_EXPIRE_TS = "ETS";
    private ITokenSerializer iSerializer;

    public TokenObject() {
        this.iSerializer = new TokenJsonSerializer();
    }

    public TokenObject(ITokenSerializer iTokenSerializer) {
        this.iSerializer = Objects.isNull(iTokenSerializer) ? new TokenJsonSerializer() : iTokenSerializer;
    }

    public String serialization() {
        return this.iSerializer.serializer(this);
    }

    public TokenObject deserialization(String tokenString) {
        return this.iSerializer.deserializer(tokenString, this);
    }

    public TokenObject set(String key, String value) {
        this.valueMap.put(key, value);
        return this;
    }

    public TokenObject set(String key, Long value) {
        this.valueMap.put(key, value);
        return this;
    }

    public TokenObject setVersion(long value) {
        this.valueMap.put(TOKEN_FIELD_VERSION, value);
        return this;
    }

    public TokenObject setCreateTime(long value) {
        this.valueMap.put(TOKEN_FIELD_CREATE_TS, value);
        return this;
    }

    public TokenObject setCreateTime() {
        this.valueMap.put(TOKEN_FIELD_CREATE_TS, System.currentTimeMillis());
        return this;
    }

    public TokenObject setExpireTime(long value) {
        this.valueMap.put(TOKEN_FIELD_EXPIRE_TS, value);
        return this;
    }

    public long getVersion() {
        return this.getLongValue(TOKEN_FIELD_VERSION, 0L);
    }

    public long getCreateTime() {
        return this.getLongValue(TOKEN_FIELD_CREATE_TS, 0L);
    }

    public long getExpireTime() {
        return this.getLongValue(TOKEN_FIELD_EXPIRE_TS, 0L);
    }

    public <T> T getValue(String key, Class valueType) {
        Object value = this.valueMap.get(key);
        if (Objects.isNull(value)) {
            return null;
        }
        if (value.getClass() == valueType) {
            return (T)value;
        }
        return null;
    }

    public String getStringValue(String key) {
        return (String)this.getValue(key, String.class);
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long dft) {
        Long l = (Long)this.getValue(key, Long.class);
        return l == null ? dft : l;
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }
}

