/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.web.filter.crypt;

import com.google.common.base.Strings;
import com.gs.common.config.config.ConfigTools3;

public class CryptACL {
    private static String CRYPT_KEY_ENABLE = "crypt.response.enable";
    private static String CRYPT_KEY_DISABLE = "crypt.response.disable";
    private static String CRYPT_KEY_ENABLE_CONTENT_TYPE = "crypt.response.enable.contentType";
    private static String CRYPT_KEY_ENABLE_DEBUG = "crypt.enable.debug";

    public static boolean isContentTypeCrypt(String contentType) {
        return ConfigTools3.getAsList(CRYPT_KEY_ENABLE_CONTENT_TYPE).contains(contentType);
    }

    public static boolean isCryptEnable(String api) {
        return ConfigTools3.getBoolean(CryptACL.getCryptKey(api), ConfigTools3.getBoolean(CRYPT_KEY_ENABLE, false));
    }

    public static boolean isResponseCryptDisable(String api) {
        return ConfigTools3.getBoolean(CryptACL.getCryptResKey(api), !ConfigTools3.getBoolean(CRYPT_KEY_ENABLE, false));
    }

    public static boolean isDebugTime() {
        return ConfigTools3.getBoolean(CRYPT_KEY_ENABLE_DEBUG, false);
    }

    private static String getCryptKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_ENABLE, Strings.nullToEmpty((String)api));
    }

    private static String getCryptResKey(String api) {
        return String.format("%s.%s", CRYPT_KEY_DISABLE, Strings.nullToEmpty((String)api));
    }
}

