/*
 * Decompiled with CFR 0.152.
 */
package com.gs.common.web.filter.crypt.v2;

import com.google.common.collect.Maps;
import com.gs.common.base.exception.ApiException;
import com.gs.common.web.filter.crypt.v2.ICryptProvider;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptFactory {
    private static final Logger logger = LoggerFactory.getLogger(CryptFactory.class);
    private static Map<String, ICryptProvider> providerMap = Maps.newHashMap();

    public static void regProvider(ICryptProvider ... providers) {
        for (ICryptProvider provider : providers) {
            if (!Objects.nonNull(provider)) continue;
            providerMap.put(provider.getProtocol(), provider);
            logger.info("CryptFactory:regCryptProvider[{}]", (Object)provider.getProtocol());
        }
    }

    public static ICryptProvider getProvider(String protocol) throws ApiException {
        ICryptProvider provider = providerMap.get(protocol);
        if (Objects.isNull(provider)) {
            logger.error("CryptFactory protocol[{}] NOT config provider", (Object)protocol);
            throw new ApiException(-9991, String.format("Protocol[%s] NOT config", protocol));
        }
        return provider;
    }
}

