/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.config.configcenter.common;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOverrideTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigOverrideTools.class);
    private static final String NO_LEVELS = "";
    private static Map<Integer, String> levelsMap = Maps.newHashMap();

    public static void initLevels(String project, String module, String env, String region) {
        List<String> list = Arrays.asList(project, module, env, region);
        levelsMap.put(1, NO_LEVELS);
        for (int i = 0; i < list.size() && !Strings.isNullOrEmpty((String)list.get(i)) && levelsMap.size() <= 5; ++i) {
            if (i == 0) {
                levelsMap.put(i + 2, list.get(i));
            } else {
                levelsMap.put(i + 2, levelsMap.get(i + 1) + "." + list.get(i));
            }
            logger.info("[Init levels:{},{}th]", (Object)list.get(i), (Object)i);
        }
    }

    public static Map<String, Integer> getDataIdsWithWeights(String configFileName) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(configFileName, 1);
        for (int i = 2; i <= levelsMap.size(); ++i) {
            if (!Objects.nonNull(levelsMap.get(i))) continue;
            logger.info("[Get DataID:{},weight:{}]", (Object)(levelsMap.get(i) + "." + configFileName), (Object)i);
            map.put(levelsMap.get(i) + "." + configFileName, i);
        }
        return map;
    }

    public static int getConfigFileWight(String dataId) {
        for (int i = levelsMap.size(); i > 1; --i) {
            if (!Objects.nonNull(levelsMap.get(i)) || !dataId.contains(levelsMap.get(i) + ".")) continue;
            logger.info("[Judge dataID:{},weight:{}]", (Object)dataId, (Object)i);
            return i;
        }
        logger.info("[Judge DataID:{},weight:{}]", (Object)dataId, (Object)1);
        return 1;
    }

    public static String getConfigFileNameFromDataId(String dataId, int weight) {
        if (weight <= 1) {
            return dataId;
        }
        return dataId.substring(levelsMap.get(weight).length() + 1);
    }
}

