/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.diagnosis;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestTools {
    private static final Logger logger = LoggerFactory.getLogger(ManifestTools.class);
    private Map<String, Object> manifestMap = Maps.newHashMap();

    public static ManifestTools getInstance() {
        return ManifestInfoHolder.INSTANCE;
    }

    private ManifestTools() {
        this.loadManifest();
    }

    private void loadManifest() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    URL url = resEnum.nextElement();
                    String jarName = url.toString();
                    if (jarName.contains("BOOT-INF")) continue;
                    jarName = jarName.replace("jar:file:", "").replace("!/META-INF/MANIFEST.MF", "");
                    logger.info("load:{}", (Object)jarName);
                    JarFile jarFile = new JarFile(jarName, false);
                    Manifest manifest = jarFile.getManifest();
                    manifest.getMainAttributes().forEach((k1, v1) -> {
                        this.manifestMap.put(k1.toString(), v1);
                        logger.info("{}={}", (Object)k1.toString(), v1);
                    });
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }
        catch (IOException e1) {
            logger.error("Exception", (Throwable)e1);
        }
    }

    public String getManifest(String name) {
        if (this.manifestMap.isEmpty()) {
            return "";
        }
        return this.manifestMap.getOrDefault(name, "").toString();
    }

    private static class ManifestInfoHolder {
        private static final ManifestTools INSTANCE = new ManifestTools();

        private ManifestInfoHolder() {
        }
    }
}

