/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.util.InetSocketAddressUtil;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttProxyConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttClientTransportConfigImpl
implements MqttClientTransportConfig {
    @NotNull
    public static final MqttClientTransportConfigImpl DEFAULT = new MqttClientTransportConfigImpl(InetSocketAddressUtil.create("localhost", 1883), null, null, null, null, 10000, 60000);
    @NotNull
    private final InetSocketAddress serverAddress;
    @Nullable
    private final InetSocketAddress localAddress;
    @Nullable
    private final MqttClientSslConfigImpl sslConfig;
    @Nullable
    private final MqttWebSocketConfigImpl webSocketConfig;
    @Nullable
    private final MqttProxyConfigImpl proxyConfig;
    private final int socketConnectTimeoutMs;
    private final int mqttConnectTimeoutMs;

    MqttClientTransportConfigImpl(@NotNull InetSocketAddress serverAddress, @Nullable InetSocketAddress localAddress, @Nullable MqttClientSslConfigImpl sslConfig, @Nullable MqttWebSocketConfigImpl webSocketConfig, @Nullable MqttProxyConfigImpl proxyConfig, int socketConnectTimeoutMs, int mqttConnectTimeoutMs) {
        this.serverAddress = serverAddress;
        this.localAddress = localAddress;
        this.sslConfig = sslConfig;
        this.webSocketConfig = webSocketConfig;
        this.proxyConfig = proxyConfig;
        this.socketConnectTimeoutMs = socketConnectTimeoutMs;
        this.mqttConnectTimeoutMs = mqttConnectTimeoutMs;
    }

    @Override
    @NotNull
    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    @NotNull
    public InetSocketAddress getRemoteAddress() {
        return this.proxyConfig == null ? this.serverAddress : this.proxyConfig.getAddress();
    }

    @Override
    @NotNull
    public Optional<InetSocketAddress> getLocalAddress() {
        return Optional.ofNullable(this.localAddress);
    }

    @Nullable
    public InetSocketAddress getRawLocalAddress() {
        return this.localAddress;
    }

    @Override
    @NotNull
    public Optional<MqttClientSslConfig> getSslConfig() {
        return Optional.ofNullable(this.sslConfig);
    }

    @Nullable
    public MqttClientSslConfigImpl getRawSslConfig() {
        return this.sslConfig;
    }

    @Override
    @NotNull
    public Optional<MqttWebSocketConfig> getWebSocketConfig() {
        return Optional.ofNullable(this.webSocketConfig);
    }

    @Nullable
    public MqttWebSocketConfigImpl getRawWebSocketConfig() {
        return this.webSocketConfig;
    }

    @Override
    @NotNull
    public Optional<MqttProxyConfig> getProxyConfig() {
        return Optional.ofNullable(this.proxyConfig);
    }

    @Nullable
    public MqttProxyConfigImpl getRawProxyConfig() {
        return this.proxyConfig;
    }

    @Override
    public int getSocketConnectTimeoutMs() {
        return this.socketConnectTimeoutMs;
    }

    @Override
    public int getMqttConnectTimeoutMs() {
        return this.mqttConnectTimeoutMs;
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImplBuilder.Default extend() {
        return new MqttClientTransportConfigImplBuilder.Default(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttClientTransportConfigImpl)) {
            return false;
        }
        MqttClientTransportConfigImpl that = (MqttClientTransportConfigImpl)o;
        return this.serverAddress.equals(that.serverAddress) && Objects.equals(this.localAddress, that.localAddress) && Objects.equals(this.sslConfig, that.sslConfig) && Objects.equals(this.webSocketConfig, that.webSocketConfig) && Objects.equals(this.proxyConfig, that.proxyConfig) && this.socketConnectTimeoutMs == that.socketConnectTimeoutMs && this.mqttConnectTimeoutMs == that.mqttConnectTimeoutMs;
    }

    public int hashCode() {
        int result = this.serverAddress.hashCode();
        result = 31 * result + Objects.hashCode(this.localAddress);
        result = 31 * result + Objects.hashCode(this.sslConfig);
        result = 31 * result + Objects.hashCode(this.webSocketConfig);
        result = 31 * result + Objects.hashCode(this.proxyConfig);
        result = 31 * result + Integer.hashCode(this.socketConnectTimeoutMs);
        result = 31 * result + Integer.hashCode(this.mqttConnectTimeoutMs);
        return result;
    }
}

