/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImplBuilder;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttWebSocketConfigImpl
implements MqttWebSocketConfig {
    @NotNull
    static final MqttWebSocketConfigImpl DEFAULT = new MqttWebSocketConfigImpl("", "", "mqtt", 10000);
    @NotNull
    private final String serverPath;
    @NotNull
    private final String queryString;
    @NotNull
    private final String subprotocol;
    private final int handshakeTimeoutMs;

    MqttWebSocketConfigImpl(@NotNull String serverPath, @NotNull String queryString, @NotNull String subprotocol, int handshakeTimeoutMs) {
        this.serverPath = serverPath;
        this.queryString = queryString;
        this.subprotocol = subprotocol;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
    }

    @Override
    @NotNull
    public String getServerPath() {
        return this.serverPath;
    }

    @Override
    @NotNull
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    @NotNull
    public String getSubprotocol() {
        return this.subprotocol;
    }

    @Override
    public int getHandshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    @Override
    @NotNull
    public MqttWebSocketConfigImplBuilder.Default extend() {
        return new MqttWebSocketConfigImplBuilder.Default(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttWebSocketConfigImpl)) {
            return false;
        }
        MqttWebSocketConfigImpl that = (MqttWebSocketConfigImpl)o;
        return this.serverPath.equals(that.serverPath) && this.queryString.equals(that.queryString) && this.subprotocol.equals(that.subprotocol) && this.handshakeTimeoutMs == that.handshakeTimeoutMs;
    }

    public int hashCode() {
        int result = this.serverPath.hashCode();
        result = 31 * result + this.queryString.hashCode();
        result = 31 * result + this.subprotocol.hashCode();
        result = 31 * result + Integer.hashCode(this.handshakeTimeoutMs);
        return result;
    }
}

