/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.util.ByteArray;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttTopicLevel
extends ByteArray {
    @NotNull
    private static final MqttTopicLevel SINGLE_LEVEL_WILDCARD = new MqttTopicLevel(new byte[]{43});

    @NotNull
    static MqttTopicLevel of(byte @NotNull [] array, int start, int end) {
        if (MqttTopicLevel.isSingleLevelWildcard(array, start, end)) {
            return SINGLE_LEVEL_WILDCARD;
        }
        return new MqttTopicLevel(Arrays.copyOfRange(array, start, end));
    }

    private static boolean isSingleLevelWildcard(byte @NotNull [] array, int start, int end) {
        return end - start == 1 && array[start] == 43;
    }

    MqttTopicLevel(byte @NotNull [] array) {
        super(array);
    }

    byte @NotNull [] getArray() {
        return this.array;
    }

    public boolean isSingleLevelWildcard() {
        return MqttTopicLevel.isSingleLevelWildcard(this.array, this.getStart(), this.getEnd());
    }

    @NotNull
    public MqttTopicLevel trim() {
        return this;
    }

    @Nullable
    public MqttTopicFilterImpl toFilter(byte @Nullable [] prefix, boolean multiLevelWildcard) {
        byte[] bytes;
        if (prefix != null) {
            if (multiLevelWildcard) {
                bytes = new byte[prefix.length + 1 + this.array.length + 2];
                bytes[bytes.length - 2] = 47;
                bytes[bytes.length - 1] = 35;
            } else {
                bytes = new byte[prefix.length + 1 + this.array.length];
            }
            System.arraycopy(prefix, 0, bytes, 0, prefix.length);
            bytes[prefix.length] = 47;
            System.arraycopy(this.array, 0, bytes, prefix.length + 1, this.array.length);
        } else if (multiLevelWildcard) {
            bytes = new byte[this.array.length + 2];
            System.arraycopy(this.array, 0, bytes, 0, this.array.length);
            bytes[bytes.length - 2] = 47;
            bytes[bytes.length - 1] = 35;
        } else {
            bytes = this.array;
        }
        return MqttTopicFilterImpl.of(bytes);
    }
}

