/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.checkpoint.Confirmable;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttMatchingPublishFlows;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class MqttIncomingPublishConfirmable
implements Confirmable,
Runnable {
    private final long id;
    @NotNull
    private final MqttIncomingPublishFlow flow;
    @NotNull
    private final MqttMatchingPublishFlows flows;
    @NotNull
    private final AtomicBoolean confirmed = new AtomicBoolean(false);

    MqttIncomingPublishConfirmable(long id, @NotNull MqttIncomingPublishFlow flow, @NotNull MqttMatchingPublishFlows flows) {
        this.id = id;
        this.flow = flow;
        this.flows = flows;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean confirm() {
        if (this.confirmed.compareAndSet(false, true)) {
            this.flow.getEventLoop().execute((Runnable)this);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.flows.acknowledge(this.flow);
    }

    static class Qos0
    implements Confirmable {
        @NotNull
        private final AtomicBoolean confirmed = new AtomicBoolean(false);

        Qos0() {
        }

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public boolean confirm() {
            return this.confirmed.compareAndSet(false, true);
        }
    }
}

