/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicIterator;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevel;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevels;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttMatchingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlows;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.internal.util.collections.Index;
import com.hivemq.client.internal.util.collections.NodeList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5RetainHandling;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class MqttSubscribedPublishFlowTree
implements MqttSubscribedPublishFlows {
    @Nullable
    private TopicTreeNode rootNode;

    MqttSubscribedPublishFlowTree() {
    }

    @Override
    public void subscribe(@NotNull MqttSubscription subscription, int subscriptionIdentifier, @Nullable MqttSubscribedPublishFlow flow) {
        TopicTreeEntry entry = new TopicTreeEntry(subscription, subscriptionIdentifier, flow);
        MqttTopicIterator topicIterator = MqttTopicIterator.of(subscription.getTopicFilter());
        TopicTreeNode node = this.rootNode;
        if (node == null) {
            this.rootNode = node = new TopicTreeNode(null, null);
        }
        while (node != null) {
            node = node.subscribe(topicIterator, entry);
        }
    }

    @Override
    public void suback(@NotNull MqttTopicFilterImpl topicFilter, int subscriptionIdentifier, boolean error) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.suback(topicIterator, subscriptionIdentifier, error)) {
        }
        this.compact();
    }

    @Override
    public void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.unsubscribe(topicIterator)) {
        }
        this.compact();
    }

    @Override
    public void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        for (HandleList.Handle h = (HandleList.Handle)flow.getTopicFilters().getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            MqttTopicIterator topicIterator = MqttTopicIterator.of((MqttTopicFilterImpl)h.getElement());
            for (TopicTreeNode node = this.rootNode; node != null; node = node.cancel(topicIterator, flow)) {
            }
        }
    }

    @Override
    public void findMatching(@NotNull MqttTopicImpl topic, @NotNull MqttMatchingPublishFlows matchingFlows) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topic);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.findMatching(topicIterator, matchingFlows)) {
        }
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        for (TopicTreeNode node = this.rootNode; node != null; node = node.clear(cause)) {
        }
        this.rootNode = null;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull List<@NotNull MqttSubscription>> getSubscriptions() {
        TreeMap<Integer, List<MqttSubscription>> map = new TreeMap<Integer, List<MqttSubscription>>(Comparator.reverseOrder());
        if (this.rootNode != null) {
            LinkedList<IteratorNode> nodes = new LinkedList<IteratorNode>();
            nodes.add(new IteratorNode(this.rootNode, null));
            while (!nodes.isEmpty()) {
                IteratorNode node = (IteratorNode)nodes.poll();
                node.node.getSubscriptions(node.parentTopicLevels, map, nodes);
            }
        }
        return map;
    }

    private void compact() {
        if (this.rootNode != null && this.rootNode.isEmpty()) {
            this.rootNode = null;
        }
    }

    private static class IteratorNode {
        @NotNull
        final TopicTreeNode node;
        @Nullable
        final MqttTopicLevel parentTopicLevels;

        IteratorNode(@NotNull TopicTreeNode node, @Nullable MqttTopicLevel parentTopicLevels) {
            this.node = node;
            this.parentTopicLevels = parentTopicLevels;
        }
    }

    private static class TopicTreeNode {
        @NotNull
        private static final Index.Spec<TopicTreeNode, MqttTopicLevel> INDEX_SPEC = new Index.Spec<TopicTreeNode, MqttTopicLevel>(node -> node.topicLevel, 4);
        @Nullable
        private TopicTreeNode parent;
        @Nullable
        private MqttTopicLevel topicLevel;
        @Nullable
        private Index<TopicTreeNode, MqttTopicLevel> next;
        @Nullable
        private TopicTreeNode singleLevel;
        @Nullable
        private NodeList<TopicTreeEntry> entries;
        @Nullable
        private NodeList<TopicTreeEntry> multiLevelEntries;

        TopicTreeNode(@Nullable TopicTreeNode parent, @Nullable MqttTopicLevel topicLevel) {
            this.parent = parent;
            this.topicLevel = topicLevel;
        }

        @Nullable
        TopicTreeNode subscribe(@NotNull MqttTopicIterator topicIterator, @NotNull TopicTreeEntry entry) {
            if (topicIterator.hasNext()) {
                TopicTreeNode node;
                MqttTopicLevel nextLevel = topicIterator.next();
                if (nextLevel.isSingleLevelWildcard()) {
                    if (this.singleLevel == null) {
                        this.singleLevel = new TopicTreeNode(this, nextLevel.trim());
                        return this.singleLevel;
                    }
                    return this.getNext(this.singleLevel, topicIterator);
                }
                if (this.next == null) {
                    this.next = new Index<TopicTreeNode, MqttTopicLevel>(INDEX_SPEC);
                    node = null;
                } else {
                    node = this.next.get(nextLevel);
                }
                if (node == null) {
                    node = new TopicTreeNode(this, nextLevel.trim());
                    this.next.put(node);
                    return node;
                }
                return this.getNext(node, topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (this.multiLevelEntries == null) {
                    this.multiLevelEntries = new NodeList();
                }
                this.multiLevelEntries.add(entry);
            } else {
                if (this.entries == null) {
                    this.entries = new NodeList();
                }
                this.entries.add(entry);
            }
            return null;
        }

        @Nullable
        TopicTreeNode suback(@NotNull MqttTopicIterator topicIterator, int subscriptionIdentifier, boolean error) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (TopicTreeNode.suback(this.multiLevelEntries, subscriptionIdentifier, error)) {
                    this.multiLevelEntries = null;
                }
            } else if (TopicTreeNode.suback(this.entries, subscriptionIdentifier, error)) {
                this.entries = null;
            }
            this.compact();
            return null;
        }

        private static boolean suback(@Nullable NodeList<TopicTreeEntry> entries, int subscriptionIdentifier, boolean error) {
            if (entries != null) {
                for (TopicTreeEntry entry = entries.getFirst(); entry != null; entry = (TopicTreeEntry)entry.getNext()) {
                    if (entry.subscriptionIdentifier != subscriptionIdentifier) continue;
                    if (!error) {
                        entry.acknowledged = true;
                        return false;
                    }
                    if (entry.flow != null) {
                        assert (entry.handle != null) : "entry.flow != null -> entry.handle != null";
                        entry.flow.getTopicFilters().remove(entry.handle);
                    }
                    entries.remove(entry);
                    return entries.isEmpty();
                }
            }
            return false;
        }

        @Nullable
        TopicTreeNode unsubscribe(@NotNull MqttTopicIterator topicIterator) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (TopicTreeNode.unsubscribe(this.multiLevelEntries)) {
                    this.multiLevelEntries = null;
                }
            } else if (TopicTreeNode.unsubscribe(this.entries)) {
                this.entries = null;
            }
            this.compact();
            return null;
        }

        private static boolean unsubscribe(@Nullable NodeList<TopicTreeEntry> entries) {
            if (entries != null) {
                for (TopicTreeEntry entry = entries.getFirst(); entry != null; entry = (TopicTreeEntry)entry.getNext()) {
                    if (!entry.acknowledged) continue;
                    if (entry.flow != null) {
                        assert (entry.handle != null) : "entry.flow != null -> entry.handle != null";
                        entry.flow.getTopicFilters().remove(entry.handle);
                        if (entry.flow.getTopicFilters().isEmpty()) {
                            entry.flow.onComplete();
                        }
                    }
                    entries.remove(entry);
                }
                return entries.isEmpty();
            }
            return false;
        }

        @Nullable
        TopicTreeNode cancel(@NotNull MqttTopicIterator topicIterator, @NotNull MqttSubscribedPublishFlow flow) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                TopicTreeNode.cancel(this.multiLevelEntries, flow);
            } else {
                TopicTreeNode.cancel(this.entries, flow);
            }
            return null;
        }

        private static void cancel(@Nullable NodeList<TopicTreeEntry> entries, @NotNull MqttSubscribedPublishFlow flow) {
            if (entries != null) {
                for (TopicTreeEntry entry = entries.getFirst(); entry != null; entry = (TopicTreeEntry)entry.getNext()) {
                    if (entry.flow != flow) continue;
                    entry.flow = null;
                    entry.handle = null;
                    break;
                }
            }
        }

        @Nullable
        TopicTreeNode findMatching(@NotNull MqttTopicIterator topicIterator, @NotNull MqttMatchingPublishFlows matchingFlows) {
            if (topicIterator.hasNext()) {
                TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
                MqttTopicLevel nextLevel = topicIterator.next();
                TopicTreeNode nextNode = this.next == null ? null : this.next.get(nextLevel);
                TopicTreeNode singleLevel = this.singleLevel;
                if (nextNode == null) {
                    return TopicTreeNode.findNext(singleLevel, topicIterator);
                }
                if (singleLevel == null) {
                    return TopicTreeNode.findNext(nextNode, topicIterator);
                }
                MqttTopicIterator fork = topicIterator.fork();
                TopicTreeNode nextNodeNext = TopicTreeNode.findNext(nextNode, topicIterator);
                if (nextNodeNext == null) {
                    return TopicTreeNode.findNext(singleLevel, topicIterator);
                }
                TopicTreeNode singleLevelNext = TopicTreeNode.findNext(singleLevel, fork);
                if (singleLevelNext == null) {
                    return nextNodeNext;
                }
                for (TopicTreeNode node = singleLevelNext; node != null; node = node.findMatching(fork, matchingFlows)) {
                }
                return nextNodeNext;
            }
            TopicTreeNode.add(matchingFlows, this.entries);
            TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
            return null;
        }

        private static void add(@NotNull MqttMatchingPublishFlows matchingFlows, @Nullable NodeList<TopicTreeEntry> entries) {
            if (entries != null) {
                matchingFlows.subscriptionFound = true;
                for (TopicTreeEntry entry = entries.getFirst(); entry != null; entry = (TopicTreeEntry)entry.getNext()) {
                    if (entry.flow == null) continue;
                    matchingFlows.add(entry.flow);
                }
            }
        }

        @Nullable
        TopicTreeNode clear(@NotNull Throwable cause) {
            if (this.next != null) {
                return this.next.any();
            }
            if (this.singleLevel != null) {
                return this.singleLevel;
            }
            if (this.entries != null) {
                TopicTreeNode.clear(this.entries, cause);
                this.entries = null;
            }
            if (this.multiLevelEntries != null) {
                TopicTreeNode.clear(this.multiLevelEntries, cause);
                this.multiLevelEntries = null;
            }
            if (this.parent != null) {
                this.parent.removeNext(this);
            }
            return this.parent;
        }

        private static void clear(@NotNull NodeList<TopicTreeEntry> entries, @NotNull Throwable cause) {
            for (TopicTreeEntry entry = entries.getFirst(); entry != null; entry = (TopicTreeEntry)entry.getNext()) {
                if (entry.flow == null || !entry.acknowledged) continue;
                entry.flow.onError(cause);
            }
        }

        @NotNull
        private TopicTreeNode getNext(@NotNull TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            int branchIndex;
            MqttTopicLevels topicLevels;
            MqttTopicLevel topicLevelBefore;
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels && (topicLevelBefore = (topicLevels = (MqttTopicLevels)topicLevel).before(branchIndex = topicIterator.forwardWhileEqual(topicLevels))) != topicLevels) {
                MqttTopicLevel topicLevelAfter = topicLevels.after(branchIndex);
                TopicTreeNode nodeBefore = new TopicTreeNode(this, topicLevelBefore);
                if (topicLevelBefore.isSingleLevelWildcard()) {
                    this.singleLevel = nodeBefore;
                } else {
                    assert (this.next != null) : "node must be in next -> next != null";
                    this.next.put(nodeBefore);
                }
                node.parent = nodeBefore;
                node.topicLevel = topicLevelAfter;
                if (topicLevelAfter.isSingleLevelWildcard()) {
                    nodeBefore.singleLevel = node;
                } else {
                    nodeBefore.next = new Index<TopicTreeNode, MqttTopicLevel>(INDEX_SPEC);
                    nodeBefore.next.put(node);
                }
                return nodeBefore;
            }
            return node;
        }

        @Nullable
        private TopicTreeNode traverseNext(@NotNull MqttTopicIterator topicIterator) {
            MqttTopicLevel nextLevel = topicIterator.next();
            if (nextLevel.isSingleLevelWildcard()) {
                return TopicTreeNode.traverseNext(this.singleLevel, topicIterator);
            }
            if (this.next != null) {
                return TopicTreeNode.traverseNext(this.next.get(nextLevel), topicIterator);
            }
            return null;
        }

        @Nullable
        private static TopicTreeNode traverseNext(@Nullable TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            if (node == null) {
                return null;
            }
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels) {
                if (topicIterator.forwardIfEqual((MqttTopicLevels)topicLevel)) {
                    return node;
                }
                return null;
            }
            return node;
        }

        @Nullable
        private static TopicTreeNode findNext(@Nullable TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            if (node == null) {
                return null;
            }
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels) {
                if (topicIterator.forwardIfMatch((MqttTopicLevels)topicLevel)) {
                    return node;
                }
                return null;
            }
            return node;
        }

        private void compact() {
            if (this.parent != null && this.entries == null && this.multiLevelEntries == null) {
                boolean hasNext;
                boolean hasSingleLevel = this.singleLevel != null;
                boolean bl = hasNext = this.next != null;
                if (!hasSingleLevel && !hasNext) {
                    this.parent.removeNext(this);
                    this.parent.compact();
                } else if (hasSingleLevel && !hasNext) {
                    this.fuse(this.singleLevel);
                } else if (!hasSingleLevel && this.next.size() == 1) {
                    this.fuse(this.next.any());
                }
            }
        }

        private void fuse(@NotNull TopicTreeNode child) {
            assert (this.parent != null) : "parent = null -> this = root node, root node must not be fused";
            assert (this.topicLevel != null) : "topicLevel = null -> this = root node, root node must not be fused";
            assert (child.parent == this) : "this must only be fused with its child";
            assert (child.topicLevel != null) : "child.topicLevel = null -> child = root node, root node has no parent";
            TopicTreeNode parent = this.parent;
            MqttTopicLevels fusedTopicLevel = MqttTopicLevels.concat(this.topicLevel, child.topicLevel);
            child.parent = parent;
            child.topicLevel = fusedTopicLevel;
            if (fusedTopicLevel.isSingleLevelWildcard()) {
                parent.singleLevel = child;
            } else {
                assert (parent.next != null) : "this must be in parent.next -> parent.next != null";
                parent.next.put(child);
            }
        }

        private void removeNext(@NotNull TopicTreeNode node) {
            assert (node.topicLevel != null) : "topicLevel = null -> node = root node, root node has no parent";
            if (node.topicLevel.isSingleLevelWildcard()) {
                this.singleLevel = null;
            } else {
                assert (this.next != null) : "node must be in next -> next != null";
                this.next.remove(node.topicLevel);
                if (this.next.size() == 0) {
                    this.next = null;
                }
            }
        }

        boolean isEmpty() {
            return this.next == null && this.singleLevel == null && this.entries == null && this.multiLevelEntries == null;
        }

        public void getSubscriptions(@Nullable MqttTopicLevel parentTopicLevels, @NotNull @NotNull Map<@NotNull Integer, @NotNull List<@NotNull MqttSubscription>> map, @NotNull @NotNull Queue<@NotNull IteratorNode> nodes) {
            MqttTopicLevel topicLevels;
            MqttTopicLevel mqttTopicLevel = topicLevels = parentTopicLevels == null || this.topicLevel == null ? this.topicLevel : MqttTopicLevels.concat(parentTopicLevels, this.topicLevel);
            if (topicLevels != null) {
                if (this.entries != null) {
                    TopicTreeNode.getSubscriptions(this.entries, topicLevels, false, map);
                }
                if (this.multiLevelEntries != null) {
                    TopicTreeNode.getSubscriptions(this.multiLevelEntries, topicLevels, true, map);
                }
            }
            if (this.next != null) {
                this.next.forEach(node -> nodes.add(new IteratorNode((TopicTreeNode)node, topicLevels)));
            }
            if (this.singleLevel != null) {
                nodes.add(new IteratorNode(this.singleLevel, topicLevels));
            }
        }

        private static void getSubscriptions(@NotNull NodeList<TopicTreeEntry> entries, @NotNull MqttTopicLevel topicLevels, boolean multiLevelWildcard, @NotNull @NotNull Map<@NotNull Integer, @NotNull List<@NotNull MqttSubscription>> map) {
            boolean exactFound = false;
            for (TopicTreeEntry entry = entries.getLast(); entry != null; entry = (TopicTreeEntry)entry.getPrev()) {
                if (!entry.acknowledged) continue;
                if (entry.topicFilterPrefix == null) {
                    if (exactFound) continue;
                    exactFound = true;
                }
                MqttTopicFilterImpl topicFilter = topicLevels.toFilter(entry.topicFilterPrefix, multiLevelWildcard);
                assert (topicFilter != null) : "reconstructed topic filter must be valid";
                MqttQos qos = MqttSubscription.decodeQos(entry.subscriptionOptions);
                assert (qos != null) : "reconstructed qos must be valid";
                boolean noLocal = MqttSubscription.decodeNoLocal(entry.subscriptionOptions);
                Mqtt5RetainHandling retainHandling = MqttSubscription.decodeRetainHandling(entry.subscriptionOptions);
                assert (retainHandling != null) : "reconstructed retain handling must be valid";
                boolean retainAsPublished = MqttSubscription.decodeRetainAsPublished(entry.subscriptionOptions);
                MqttSubscription subscription = new MqttSubscription(topicFilter, qos, noLocal, retainHandling, retainAsPublished);
                map.computeIfAbsent(entry.subscriptionIdentifier, k -> new LinkedList()).add(subscription);
            }
        }
    }

    private static class TopicTreeEntry
    extends NodeList.Node<TopicTreeEntry> {
        final int subscriptionIdentifier;
        final byte subscriptionOptions;
        final byte @Nullable [] topicFilterPrefix;
        @Nullable
        MqttSubscribedPublishFlow flow;
        @Nullable
        HandleList.Handle<MqttTopicFilterImpl> handle;
        boolean acknowledged;

        TopicTreeEntry(@NotNull MqttSubscription subscription, int subscriptionIdentifier, @Nullable MqttSubscribedPublishFlow flow) {
            this.subscriptionIdentifier = subscriptionIdentifier;
            this.subscriptionOptions = subscription.encodeSubscriptionOptions();
            MqttTopicFilterImpl topicFilter = subscription.getTopicFilter();
            this.topicFilterPrefix = topicFilter.getPrefix();
            this.flow = flow;
            this.handle = flow == null ? null : flow.getTopicFilters().add(topicFilter);
        }
    }
}

