/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttAuthBuilder
implements Mqtt5AuthBuilder {
    @NotNull
    private final MqttUtf8StringImpl method;
    @Nullable
    private ByteBuffer data;
    @NotNull
    private final Mqtt5AuthReasonCode reasonCode;
    @Nullable
    private MqttUtf8StringImpl reasonString;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    public MqttAuthBuilder(@NotNull Mqtt5AuthReasonCode reasonCode, @NotNull MqttUtf8StringImpl method) {
        Checks.notNull(reasonCode, "Reason code");
        Checks.notNull(method, "Method");
        this.reasonCode = reasonCode;
        this.method = method;
    }

    @Override
    @NotNull
    public MqttAuthBuilder data(byte @Nullable [] data) {
        this.data = MqttChecks.binaryDataOrNull(data, "Auth data");
        return this;
    }

    @Override
    @NotNull
    public MqttAuthBuilder data(@Nullable ByteBuffer data) {
        this.data = MqttChecks.binaryDataOrNull(data, "Auth data");
        return this;
    }

    @Override
    @NotNull
    public MqttAuthBuilder reasonString(@Nullable String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttAuthBuilder reasonString(@Nullable MqttUtf8String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttAuthBuilder userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this;
    }

    @NotNull
    public MqttUserPropertiesImplBuilder.Nested<MqttAuthBuilder> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttAuthBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public MqttAuth build() {
        return new MqttAuth(this.reasonCode, this.method, this.data, this.reasonString, this.userProperties);
    }
}

