/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttBlockingClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.mqtt.MqttRxClientBuilderBase;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthView;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthViewBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishViewBuilder;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3AsyncClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3BlockingClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientView;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mqtt3RxClientViewBuilder
extends MqttRxClientBuilderBase<Mqtt3RxClientViewBuilder>
implements Mqtt3ClientBuilder {
    @Nullable
    private MqttSimpleAuth simpleAuth;
    @Nullable
    private MqttWillPublish willPublish;

    public Mqtt3RxClientViewBuilder() {
    }

    public Mqtt3RxClientViewBuilder(@NotNull MqttRxClientBuilderBase<?> clientBuilder) {
        super(clientBuilder);
    }

    @Override
    @NotNull
    public Mqtt3RxClientViewBuilder simpleAuth(@Nullable Mqtt3SimpleAuth simpleAuth) {
        this.simpleAuth = simpleAuth == null ? null : Checks.notImplemented(simpleAuth, Mqtt3SimpleAuthView.class, "Simple auth").getDelegate();
        return this;
    }

    @NotNull
    public Mqtt3SimpleAuthViewBuilder.Nested<Mqtt3RxClientViewBuilder> simpleAuth() {
        return new Mqtt3SimpleAuthViewBuilder.Nested<Mqtt3RxClientViewBuilder>(this::simpleAuth);
    }

    @Override
    @NotNull
    public Mqtt3RxClientViewBuilder willPublish(@Nullable Mqtt3Publish willPublish) {
        this.willPublish = willPublish == null ? null : Checks.notImplemented(willPublish, Mqtt3PublishView.class, "Will publish").getDelegate().asWill();
        return this;
    }

    @NotNull
    public Mqtt3PublishViewBuilder.WillNested<Mqtt3RxClientViewBuilder> willPublish() {
        return new Mqtt3PublishViewBuilder.WillNested<Mqtt3RxClientViewBuilder>(this::willPublish);
    }

    @Override
    @NotNull
    protected Mqtt3RxClientViewBuilder self() {
        return this;
    }

    @Override
    @NotNull
    public Mqtt3RxClientView build() {
        return this.buildRx();
    }

    @Override
    @NotNull
    public Mqtt3RxClientView buildRx() {
        return new Mqtt3RxClientView(this.buildRxDelegate());
    }

    @Override
    @NotNull
    public Mqtt3AsyncClientView buildAsync() {
        return new Mqtt3AsyncClientView(this.buildAsyncDelegate());
    }

    @Override
    @NotNull
    public Mqtt3BlockingClientView buildBlocking() {
        return new Mqtt3BlockingClientView(this.buildBlockingDelegate());
    }

    @NotNull
    private MqttRxClient buildRxDelegate() {
        return new MqttRxClient(this.buildClientConfig());
    }

    @NotNull
    private MqttAsyncClient buildAsyncDelegate() {
        return this.buildRxDelegate().toAsync();
    }

    @NotNull
    private MqttBlockingClient buildBlockingDelegate() {
        return this.buildRxDelegate().toBlocking();
    }

    @NotNull
    private MqttClientConfig buildClientConfig() {
        return this.buildClientConfig(MqttVersion.MQTT_3_1_1, MqttClientAdvancedConfig.DEFAULT, MqttClientConfig.ConnectDefaults.of(this.simpleAuth, null, this.willPublish));
    }
}

