/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.util;

import com.hivemq.client.internal.util.Checks;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.NotNull;

public class KeyStoreUtil {
    @NotNull
    private static final String KEYSTORE_TYPE = "JKS";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static TrustManagerFactory trustManagerFromKeystore(@NotNull File trustStoreFile, @NotNull String trustStorePassword) throws SSLException {
        Checks.notNull(trustStoreFile, "Truststore file");
        try (FileInputStream fileInputStream = new FileInputStream(trustStoreFile);){
            KeyStore keyStoreTrust = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStoreTrust.load(fileInputStream, trustStorePassword.toCharArray());
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(keyStoreTrust);
            TrustManagerFactory trustManagerFactory = tmFactory;
            return trustManagerFactory;
        }
        catch (IOException | KeyStoreException e2) {
            throw new SSLException("Not able to open or read TrustStore '" + trustStoreFile.getAbsolutePath(), e2);
        }
        catch (NoSuchAlgorithmException | CertificateException e3) {
            throw new SSLException("Not able to read certificate from TrustStore '" + trustStoreFile.getAbsolutePath(), e3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static KeyManagerFactory keyManagerFromKeystore(@NotNull File keyStoreFile, @NotNull String keyStorePassword, @NotNull String privateKeyPassword) throws SSLException {
        Checks.notNull(keyStoreFile, "Keystore file");
        try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, privateKeyPassword.toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (UnrecoverableKeyException e1) {
            throw new SSLException("Not able to recover key from KeyStore, please check your private-key-password and your keyStorePassword", e1);
        }
        catch (IOException | KeyStoreException e2) {
            throw new SSLException("Not able to open or read KeyStore '" + keyStoreFile.getAbsolutePath(), e2);
        }
        catch (NoSuchAlgorithmException | CertificateException e3) {
            throw new SSLException("Not able to read certificate from KeyStore '" + keyStoreFile.getAbsolutePath(), e3);
        }
    }
}

