/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractClient;
import com.obs.services.AbstractMultipartObjectClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import com.obs.services.model.fs.DropFileRequest;
import com.obs.services.model.fs.DropFileResult;
import com.obs.services.model.fs.GetAttributeRequest;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.ListContentSummaryResult;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileRequest;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.File;
import java.io.InputStream;

public abstract class AbstractPFSClient
extends AbstractMultipartObjectClient {
    @Override
    public ListContentSummaryResult listContentSummary(final ListContentSummaryRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListContentSummaryRequest is null");
        return this.doActionWithResult("listcontentsummary", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ListContentSummaryResult>(){

            @Override
            public ListContentSummaryResult action() throws ServiceException {
                return AbstractPFSClient.this.listContentSummaryImpl(request);
            }
        });
    }

    @Override
    public RenameObjectResult renameObject(String bucketName, String objectKey, String newObjectKey) throws ObsException {
        RenameObjectRequest request = new RenameObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setNewObjectKey(newObjectKey);
        return this.renameObject(request);
    }

    @Override
    public RenameObjectResult renameObject(final RenameObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        return this.doActionWithResult("renameObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RenameObjectResult>(){

            @Override
            public RenameObjectResult action() throws ServiceException {
                return AbstractPFSClient.this.renameObjectImpl(request);
            }
        });
    }

    @Override
    public TruncateObjectResult truncateObject(String bucketName, String objectKey, long newLength) throws ObsException {
        TruncateObjectRequest request = new TruncateObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setNewLength(newLength);
        return this.truncateObject(request);
    }

    @Override
    public TruncateObjectResult truncateObject(final TruncateObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "TruncateObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getNewLength(), "NewLength is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        return this.doActionWithResult("truncateObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<TruncateObjectResult>(){

            @Override
            public TruncateObjectResult action() throws ServiceException {
                return AbstractPFSClient.this.truncateObjectImpl(request);
            }
        });
    }

    @Override
    public ModifyObjectResult modifyObject(String bucketName, String objectKey, long position, File file) throws ObsException {
        ModifyObjectRequest request = new ModifyObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setPosition(position);
        request.setFile(file);
        return this.modifyObject(request);
    }

    @Override
    public ModifyObjectResult modifyObject(String bucketName, String objectKey, long position, InputStream input) throws ObsException {
        ModifyObjectRequest request = new ModifyObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setPosition(position);
        request.setInput(input);
        return this.modifyObject(request);
    }

    @Override
    public ModifyObjectResult modifyObject(final ModifyObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ModifyObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getPosition(), "position is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("modifyObject", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ModifyObjectResult>(){

            @Override
            public ModifyObjectResult action() throws ServiceException {
                return AbstractPFSClient.this.modifyObjectImpl(request);
            }
        });
    }

    @Override
    public ObsFSAttribute getAttribute(GetAttributeRequest request) throws ObsException {
        return (ObsFSAttribute)this.getObjectMetadata(request);
    }

    @Override
    public ReadFileResult readFile(ReadFileRequest request) throws ObsException {
        return (ReadFileResult)this.getObject(request);
    }

    @Override
    public ObsFSFile appendFile(WriteFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "WriteFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ObjectMetadata metadata = this.getObjectMetadata(new GetObjectMetadataRequest(request.getBucketName(), request.getObjectKey()));
        if (request.getPosition() >= 0L && request.getPosition() != metadata.getNextPosition()) {
            throw new IllegalArgumentException("Where you proposed append to is not equal to length");
        }
        request.setPosition(metadata.getNextPosition());
        return this.writeFile(request);
    }

    @Override
    public RenameResult renameFile(final RenameRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        return this.doActionWithResult("rename", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RenameResult>(){

            @Override
            public RenameResult action() throws ServiceException {
                return AbstractPFSClient.this.renameFileImpl(request);
            }
        });
    }

    @Override
    public RenameResult renameFolder(RenameRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        String delimiter = this.getFileSystemDelimiter();
        if (!request.getObjectKey().endsWith(delimiter)) {
            request.setObjectKey(request.getObjectKey() + delimiter);
        }
        if (!request.getNewObjectKey().endsWith(delimiter)) {
            request.setNewObjectKey(request.getNewObjectKey() + delimiter);
        }
        return this.renameFile(request);
    }

    @Override
    public TruncateFileResult truncateFile(final TruncateFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "TruncateFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        return this.doActionWithResult("truncateFile", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<TruncateFileResult>(){

            @Override
            public TruncateFileResult action() throws ServiceException {
                return AbstractPFSClient.this.truncateFileImpl(request);
            }
        });
    }

    @Override
    public DropFileResult dropFile(final DropFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "DropFileRequest is null");
        return this.doActionWithResult("dropFile", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<DropFileResult>(){

            @Override
            public DropFileResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return (DropFileResult)AbstractPFSClient.this.deleteObjectImpl(new DeleteObjectRequest(request.getBucketName(), request.getObjectKey(), request.getVersionId()));
            }
        });
    }
}

