/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.ObsBucketBaseService;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCustomDomainInfo;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.DeleteBucketCustomDomainRequest;
import com.obs.services.model.GetBucketCustomDomainRequest;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.Permission;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketCustomDomainRequest;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.WebsiteConfiguration;
import java.util.HashMap;
import java.util.Map;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class ObsBucketAdvanceService
extends ObsBucketBaseService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsBucketAdvanceService.class);

    protected HeaderResponse setBucketVersioningImpl(SetBucketVersioningRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transVersioningConfiguration(request.getBucketName(), request.getStatus() != null ? request.getStatus().getCode() : null);
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParams, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected BucketVersioningConfiguration getBucketVersioningImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        BucketVersioningConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketVersioningHandler.class, false).getVersioningStatus();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setBucketRequestPaymentImpl(SetBucketRequestPaymentRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transRequestPaymentConfiguration(request.getBucketName(), request.getPayer() != null ? request.getPayer().getCode() : null);
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParams, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected RequestPaymentConfiguration getBucketRequestPaymentImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        RequestPaymentConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.RequestPaymentHandler.class, false).getRequestPaymentConfiguration();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setBucketNotificationImpl(SetBucketNotificationRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transBucketNotificationConfiguration(request.getBucketNotificationConfiguration());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected BucketNotificationConfiguration getBucketNotificationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketNotificationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketNotificationConfigurationHandler.class, false).getBucketNotificationConfiguration();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse setBucketWebsiteConfigurationImpl(SetBucketWebsiteRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transWebsiteConfiguration(request.getWebsiteConfig());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected WebsiteConfiguration getBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        WebsiteConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketWebsiteConfigurationHandler.class, false).getWebsiteConfig();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketLifecycleConfigurationImpl(SetBucketLifecycleRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        String xml = this.getIConvertor().transLifecycleConfiguration(request.getLifecycleConfig());
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected LifecycleConfiguration getBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        LifecycleConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketLifecycleConfigurationHandler.class, false).getLifecycleConfig();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse deleteBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketTaggingImpl(SetBucketTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transBucketTagInfo(request.getBucketTagInfo());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        return this.build(response);
    }

    protected BucketTagInfo getBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketTagInfo result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketTagInfoHandler.class, false).getBucketTagInfo();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketEncryptionImpl(SetBucketEncryptionRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String encryptAsXml = request.getBucketEncryption() == null ? "" : this.getIConvertor().transBucketEcryption(request.getBucketEncryption());
        metadata.put("Content-Length", String.valueOf(encryptAsXml.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", encryptAsXml), true);
        return this.build(response);
    }

    protected BucketEncryption getBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketEncryption ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketEncryptionHandler.class, false).getEncryption();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketReplicationConfigurationImpl(SetBucketReplicationRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transReplicationConfiguration(request.getReplicationConfiguration());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        return this.build(response);
    }

    protected ReplicationConfiguration getBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        ReplicationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketReplicationConfigurationHandler.class, false).getReplicationConfiguration();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketCorsImpl(SetBucketCorsRequest request) throws ServiceException {
        String corsXML = request.getBucketCors() == null ? "" : this.getIConvertor().transBucketCors(request.getBucketCors());
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        metadata.put("Content-MD5", ServiceUtils.computeMD5(corsXML));
        metadata.put("Content-Length", String.valueOf(corsXML.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", corsXML), true);
        return this.build(response);
    }

    protected BucketCors getBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketCors ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketCorsHandler.class, false).getConfiguration();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected HeaderResponse setBucketQuotaImpl(SetBucketQuotaRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String quotaAsXml = request.getBucketQuota() == null ? "" : this.getIConvertor().transBucketQuota(request.getBucketQuota());
        metadata.put("Content-Length", String.valueOf(quotaAsXml.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", quotaAsXml), true);
        return this.build(response);
    }

    protected BucketQuota getBucketQuotaImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketQuota ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketQuotaHandler.class, false).getQuota();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketAclImpl(SetBucketAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor().transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(metadata, request.getAcl());
        if (isExtraAclPutRequired) {
            String aclAsXml = request.getAcl() == null ? "" : this.getIConvertor().transAccessControlList(request.getAcl(), true);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, entity, true);
        return this.build(response);
    }

    protected AccessControlList getBucketAclImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketLoggingConfigurationImpl(SetBucketLoggingRequest request) throws ServiceException {
        if (request.getLoggingConfiguration().isLoggingEnabled() && request.isUpdateTargetACLifRequired() && this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS) {
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = "http://acs.amazonaws.com/groups/s3/LogDelivery";
            BaseBucketRequest getBucketAclRequest = new BaseBucketRequest(request.getLoggingConfiguration().getTargetBucketName());
            getBucketAclRequest.setRequesterPays(request.isRequesterPays());
            AccessControlList logBucketACL = this.getBucketAclImpl(getBucketAclRequest);
            for (GrantAndPermission gap : logBucketACL.getGrantAndPermissions()) {
                if (!(gap.getGrantee() instanceof GroupGrantee)) continue;
                GroupGrantee grantee = (GroupGrantee)gap.getGrantee();
                if (!groupIdentifier.equals(this.getIConvertor().transGroupGrantee(grantee.getGroupGranteeType()))) continue;
                if (Permission.PERMISSION_WRITE.equals(gap.getPermission())) {
                    isSetLoggingGroupWrite = true;
                    continue;
                }
                if (!Permission.PERMISSION_READ_ACP.equals(gap.getPermission())) continue;
                isSetLoggingGroupReadACP = true;
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                if (log.isWarnEnabled()) {
                    log.warn("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now");
                }
                if (logBucketACL.getOwner() != null) {
                    logBucketACL.getOwner().setDisplayName(null);
                }
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                SetBucketAclRequest aclReqeust = new SetBucketAclRequest(request.getBucketName(), logBucketACL);
                aclReqeust.setRequesterPays(request.isRequesterPays());
                this.setBucketAclImpl(aclReqeust);
            } else if (log.isDebugEnabled()) {
                log.debug("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' has the necessary ACL settings");
            }
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String statusAsXml = request.getLoggingConfiguration() == null ? "" : this.getIConvertor().transBucketLoggingConfiguration(request.getLoggingConfiguration());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", statusAsXml), true);
        return this.build(response);
    }

    protected BucketLoggingConfiguration getBucketLoggingConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketLoggingConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLoggingHandler.class, false).getBucketLoggingStatus();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketDirectColdAccessImpl(SetBucketDirectColdAccessRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transBucketDirectColdAccess(request.getAccess());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        return this.build(response);
    }

    protected BucketDirectColdAccess getBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketDirectColdAccess result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketDirectColdAccessHandler.class, false).getBucketDirectColdAccess();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    protected BucketCustomDomainInfo getBucketCustomDomainImpl(GetBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        BucketCustomDomainInfo ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketCustomDomainHandler.class, true).getBucketTagInfo();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setBucketCustomDomainImpl(SetBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), request.getDomainName());
        Map<String, String> metadata = this.transRequestPaymentHeaders(request, null, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParams, null, true);
        return this.build(response);
    }

    protected HeaderResponse deleteBucketCustomDomainImpl(DeleteBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), request.getDomainName());
        Response response = this.performRestDelete(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }
}

