/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsBucketAdvanceService;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.GetObjectAclRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.SetObjectAclRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.DropFileResult;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileResult;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class ObsObjectBaseService
extends ObsBucketAdvanceService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsObjectBaseService.class);

    protected boolean doesObjectExistImpl(GetObjectMetadataRequest request) throws ServiceException {
        boolean doesObjectExist;
        block4: {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
            this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getVersionId() != null) {
                params.put("versionId", request.getVersionId());
            }
            doesObjectExist = false;
            try {
                Response response = this.performRestHead(request.getBucketName(), request.getObjectKey(), params, headers);
                if (200 == response.code()) {
                    doesObjectExist = true;
                }
            }
            catch (ServiceException ex) {
                if (404 == ex.getResponseCode()) break block4;
                throw ex;
            }
        }
        return doesObjectExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile putObjectImpl(PutObjectRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transPutObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), null, result.getBody(), true, false, request.isEncodeHeaders());
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders().versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected ObsObject getObjectImpl(GetObjectRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transGetObjectRequest(request);
        if (request.getRequestParameters() != null) {
            result.getParams().putAll(request.getRequestParameters());
        }
        return (ObsObject)this.getObjectImpl(false, request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), request.getProgressListener(), request.getProgressInterval(), request.isEncodeHeaders());
    }

    protected Object getObjectImpl(boolean headOnly, String bucketName, String objectKey, Map<String, String> headers, Map<String, String> params, ProgressListener progressListener, long progressInterval, boolean needEncode) throws ServiceException {
        int readBufferSize;
        Response response = headOnly ? this.performRestHead(bucketName, objectKey, params, headers) : this.performRestGet(bucketName, objectKey, params, headers, false, needEncode);
        ObsFSAttribute objMetadata = this.getObsFSAttributeFromResponse(response, needEncode);
        if (headOnly) {
            response.close();
            return objMetadata;
        }
        ReadFileResult obsObject = new ReadFileResult();
        obsObject.setObjectKey(objectKey);
        obsObject.setBucketName(bucketName);
        obsObject.setMetadata(objMetadata);
        InputStream input = response.body().byteStream();
        if (progressListener != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(objMetadata.getContentLength(), 0L, progressListener, progressInterval > 0L ? progressInterval : 102400L);
            input = new ProgressInputStream(input, progressManager);
        }
        if ((readBufferSize = this.obsProperties.getIntProperty("httpclient.read-buffer-size", 8192)) > 0) {
            input = new BufferedInputStream(input, readBufferSize);
        }
        obsObject.setObjectContent(input);
        return obsObject;
    }

    protected DeleteObjectsResult deleteObjectsImpl(DeleteObjectsRequest deleteObjectsRequest) throws ServiceException {
        String xml = this.getIConvertor().transKeyAndVersion(deleteObjectsRequest.getKeyAndVersions(), deleteObjectsRequest.isQuiet(), deleteObjectsRequest.getEncodingType());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DELETE.getOriginalStringCode(), "");
        this.transRequestPaymentHeaders(deleteObjectsRequest, metadata, this.getIHeaders());
        Response httpResponse = this.performRestPost(deleteObjectsRequest.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), false);
        this.verifyResponseContentType(httpResponse);
        DeleteObjectsResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.DeleteObjectsHandler.class, true).getMultipleDeleteResult();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected DeleteObjectResult deleteObjectImpl(DeleteObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            requestParameters.put("versionId", request.getVersionId());
        }
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        DropFileResult result = new DropFileResult(Boolean.valueOf(response.header(this.getIHeaders().deleteMarkerHeader())), request.getObjectKey(), response.header(this.getIHeaders().versionIdHeader()));
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected CopyObjectResult copyObjectImpl(CopyObjectRequest request) throws ServiceException {
        CopyObjectResult copyRet;
        block4: {
            AbstractRequestConvertor.TransResult result = this.transCopyObjectRequest(request);
            AccessControlList acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
            Response response = this.performRestPut(request.getDestinationBucketName(), request.getDestinationObjectKey(), result.getHeaders(), null, null, false, false, request.isEncodeHeaders());
            this.verifyResponseContentType(response);
            XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyObjectResultHandler.class, false);
            copyRet = new CopyObjectResult(handler.getETag(), handler.getLastModified(), response.header(this.getIHeaders().versionIdHeader()), response.header(this.getIHeaders().copySourceVersionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            this.setHeadersAndStatus(copyRet, response);
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(request.getDestinationBucketName(), request.getDestinationObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return copyRet;
    }

    protected ObjectMetadata setObjectMetadataImpl(SetObjectMetadataRequest request) {
        AbstractRequestConvertor.TransResult result = this.transSetObjectMetadataRequest(request);
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true, false, request.isEncodeHeaders());
        return this.getObsFSAttributeFromResponse(response, request.isEncodeHeaders());
    }

    protected ObsFSAttribute getObjectMetadataImpl(GetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return (ObsFSAttribute)this.getObjectImpl(true, request.getBucketName(), request.getObjectKey(), headers, params, null, -1L, request.isEncodeHeaders());
    }

    protected HeaderResponse setObjectAclImpl(SetObjectAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            requestParameters.put("versionId", request.getVersionId());
        }
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor().transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAclObject(metadata, request.getAcl());
        if (isExtraAclPutRequired) {
            String aclAsXml = request.getAcl() == null ? "" : this.getIConvertor().transAccessControlList(request.getAcl(), false);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), metadata, requestParameters, entity, true);
        return this.build(response);
    }

    protected AccessControlList getObjectAclImpl(GetObjectAclRequest getObjectAclRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (ServiceUtils.isValid(getObjectAclRequest.getVersionId())) {
            requestParameters.put("versionId", getObjectAclRequest.getVersionId().trim());
        }
        Response httpResponse = this.performRestGet(getObjectAclRequest.getBucketName(), getObjectAclRequest.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(getObjectAclRequest, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected String getObjectUrl(String bucketName, String objectKey) {
        boolean pathStyle = this.isPathStyle();
        boolean https = this.getHttpsOnly();
        boolean isCname = this.isCname();
        return (https ? "https://" : "http://") + (pathStyle || isCname ? "" : bucketName + ".") + this.getEndpoint() + ":" + (https ? this.getHttpsPort() : this.getHttpPort()) + "/" + (pathStyle ? bucketName + "/" : "") + RestUtils.uriEncode(objectKey, false);
    }

    private Map<String, Object> cleanUserMetadata(Map<String, Object> originalHeaders, boolean decodeHeaders) {
        TreeMap<String, Object> userMetadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, Object> entry : originalHeaders.entrySet()) {
            String key = entry.getKey();
            if (!key.toLowerCase().startsWith("x-obs-meta-") && !key.toLowerCase().startsWith("x-amz-meta-")) continue;
            Object originalValue = originalHeaders.get(key);
            try {
                if (originalValue instanceof ArrayList) {
                    this.cleanListMetadata(originalHeaders, decodeHeaders, userMetadata, key);
                    continue;
                }
                if (decodeHeaders) {
                    userMetadata.put(key.substring(11), URLDecoder.decode((String)originalValue, "UTF-8"));
                    continue;
                }
                userMetadata.put(key.substring(11), originalHeaders.get(key));
            }
            catch (UnsupportedEncodingException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error to decode value of key:" + key);
            }
        }
        return userMetadata;
    }

    private void cleanListMetadata(Map<String, Object> originalHeaders, boolean decodeHeaders, Map<String, Object> userMetadata, String key) throws UnsupportedEncodingException {
        ArrayList<String> cleanedValue = new ArrayList<String>();
        for (Object v : (List)originalHeaders.get(key)) {
            if (decodeHeaders) {
                cleanedValue.add(URLDecoder.decode((String)v, "UTF-8"));
                continue;
            }
            cleanedValue.add((String)v);
        }
        userMetadata.put(key.substring(11), cleanedValue);
    }

    private ObsFSAttribute getObsFSAttributeFromResponse(Response response, boolean needDecode) {
        ObsFSAttribute objMetadata;
        block15: {
            String fsMode;
            block14: {
                Date lastModifiedDate;
                block13: {
                    lastModifiedDate = null;
                    String lastModified = response.header("Last-Modified");
                    if (lastModified != null) {
                        try {
                            lastModifiedDate = ServiceUtils.parseRfc822Date(lastModified);
                        }
                        catch (ParseException e) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn("Response last-modified is not well-format", e);
                        }
                    }
                }
                objMetadata = new ObsFSAttribute();
                objMetadata.setLastModified(lastModifiedDate);
                objMetadata.setContentEncoding(response.header("Content-Encoding"));
                objMetadata.setContentType(response.header("Content-Type"));
                objMetadata.setContentDisposition(response.header("Content-Disposition"));
                objMetadata.setContentLanguage(response.header("Content-Language"));
                objMetadata.setCacheControl(response.header("Cache-Control"));
                objMetadata.setExpires(response.header("Expires"));
                String contentLength = response.header("Content-Length");
                if (contentLength != null) {
                    try {
                        objMetadata.setContentLength(Long.parseLong(contentLength));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn("Response content-length is not well-format", e);
                    }
                }
            }
            if ((fsMode = response.header(this.getIHeaders().fsModeHeader())) != null) {
                objMetadata.setMode(Integer.parseInt(fsMode));
            }
            objMetadata.setWebSiteRedirectLocation(response.header(this.getIHeaders().websiteRedirectLocationHeader()));
            objMetadata.setObjectStorageClass(StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            String etag = response.header("ETag");
            objMetadata.setEtag(etag);
            if (etag != null && !etag.contains("-")) {
                String md5 = etag;
                if (md5.startsWith("\"")) {
                    md5 = md5.substring(1);
                }
                if (md5.endsWith("\"")) {
                    md5 = md5.substring(0, md5.length() - 1);
                }
                try {
                    objMetadata.setContentMd5(ServiceUtils.toBase64(ServiceUtils.fromHex(md5)));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug(e.getMessage(), e);
                }
            }
        }
        objMetadata.setAppendable("Appendable".equals(response.header(this.getIHeaders().objectTypeHeader())));
        String nextPosition = response.header(this.getIHeaders().nextPositionHeader(), "-1");
        objMetadata.setNextPosition(Long.parseLong(nextPosition));
        if (objMetadata.getNextPosition() == -1L) {
            objMetadata.setNextPosition(Long.parseLong(response.header("Content-Length", "-1")));
        }
        this.setHeadersAndStatus(objMetadata, response, needDecode);
        objMetadata.setUserMetadata(this.cleanUserMetadata(objMetadata.getOriginalHeaders(), needDecode));
        return objMetadata;
    }
}

