/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.GenericRequest;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PutObjectBasicRequest
extends GenericRequest {
    protected String bucketName;
    protected String objectKey;
    protected Map<ExtensionObjectPermissionEnum, Set<String>> extensionPermissionMap;
    protected AccessControlList acl;
    protected String successRedirectLocation;
    protected SseKmsHeader sseKmsHeader;
    protected boolean encodeHeaders = true;
    protected SseCHeader sseCHeader;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public SseKmsHeader getSseKmsHeader() {
        return this.sseKmsHeader;
    }

    public void setSseKmsHeader(SseKmsHeader sseKmsHeader) {
        this.sseKmsHeader = sseKmsHeader;
    }

    public SseCHeader getSseCHeader() {
        return this.sseCHeader;
    }

    public void setSseCHeader(SseCHeader sseCHeader) {
        this.sseCHeader = sseCHeader;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getSuccessRedirectLocation() {
        return this.successRedirectLocation;
    }

    public void setSuccessRedirectLocation(String successRedirectLocation) {
        this.successRedirectLocation = successRedirectLocation;
    }

    public void grantExtensionPermission(String domainId, ExtensionObjectPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        Set<String> users = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (users == null) {
            users = new HashSet<String>();
            this.getExtensionPermissionMap().put(extensionPermissionEnum, users);
        }
        users.add(domainId.trim());
    }

    public void withdrawExtensionPermission(String domainId, ExtensionObjectPermissionEnum extensionPermissionEnum) {
        if (extensionPermissionEnum == null || !ServiceUtils.isValid(domainId)) {
            return;
        }
        domainId = domainId.trim();
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds != null) {
            domainIds.remove(domainId);
        }
    }

    public void withdrawExtensionPermissions(String domainId) {
        if (ServiceUtils.isValid(domainId)) {
            for (Map.Entry<ExtensionObjectPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId.trim())) continue;
                entry.getValue().remove(domainId);
            }
        }
    }

    public Set<ExtensionObjectPermissionEnum> getAllGrantPermissions() {
        return this.getExtensionPermissionMap().keySet();
    }

    public Set<String> getDomainIdsByGrantPermission(ExtensionObjectPermissionEnum extensionPermissionEnum) {
        Set<String> domainIds = this.getExtensionPermissionMap().get((Object)extensionPermissionEnum);
        if (domainIds == null) {
            domainIds = new HashSet<String>();
        }
        return domainIds;
    }

    public Set<ExtensionObjectPermissionEnum> getGrantPermissionsByDomainId(String domainId) {
        HashSet<ExtensionObjectPermissionEnum> grantPermissions = new HashSet<ExtensionObjectPermissionEnum>();
        if (ServiceUtils.isValid(domainId)) {
            domainId = domainId.trim();
            for (Map.Entry<ExtensionObjectPermissionEnum, Set<String>> entry : this.getExtensionPermissionMap().entrySet()) {
                if (!entry.getValue().contains(domainId)) continue;
                grantPermissions.add(entry.getKey());
            }
        }
        return grantPermissions;
    }

    public Map<ExtensionObjectPermissionEnum, Set<String>> getExtensionPermissionMap() {
        if (this.extensionPermissionMap == null) {
            this.extensionPermissionMap = new HashMap<ExtensionObjectPermissionEnum, Set<String>>();
        }
        return this.extensionPermissionMap;
    }

    public void setExtensionPermissionMap(Map<ExtensionObjectPermissionEnum, Set<String>> extensionPermissionMap) {
        if (extensionPermissionMap == null) {
            return;
        }
        this.extensionPermissionMap = extensionPermissionMap;
    }

    public void setIsEncodeHeaders(boolean encodeHeaders) {
        this.encodeHeaders = encodeHeaders;
    }

    public boolean isEncodeHeaders() {
        return this.encodeHeaders;
    }
}

