/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELFunction
implements Function,
ApplicationContextAware,
DisposableBean {
    private ExpressionParser parser = new SpelExpressionParser();
    private Map<String, Expression> expressionCache = new HashMap<String, Expression>();
    private ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object call(Object[] args, Context context) {
        if (args.length >= 1 && args[0] instanceof String && args[0] != null) {
            String spel = (String)args[0];
            Expression expression = this.getExpression(spel);
            if (args.length >= 2 && args[1] != null) {
                return expression.getValue(this.createEvaluationContext(args[1], context));
            }
            return expression.getValue(this.createEvaluationContext(Collections.emptyMap(), context));
        }
        return null;
    }

    private synchronized Expression getExpression(String spel) {
        Expression expression = this.expressionCache.get(spel);
        if (expression == null) {
            expression = this.parser.parseExpression(spel);
            this.expressionCache.put(spel, expression);
        }
        return expression;
    }

    private EvaluationContext createEvaluationContext(Object rootObject, Context beetlContext) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject);
        context.setVariable("context", (Object)beetlContext);
        context.setVariable("global", (Object)beetlContext.globalVar);
        context.setVariable("ctxPath", beetlContext.getGlobal("ctxPath"));
        context.setVariable("servlet", beetlContext.getGlobal("servlet"));
        context.setVariable("parameter", beetlContext.getGlobal("parameter"));
        context.setVariable("request", beetlContext.getGlobal("request"));
        context.setVariable("session", beetlContext.getGlobal("session"));
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        return context;
    }

    public void destroy() {
        this.expressionCache.clear();
    }
}

